/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jsky.util.Preferences;
import org.jfree.ui.DateChooserPanel;

public class DateChooserDialog
extends JDialog {
    private DateChooserPanel _dateChooserPanel;
    private boolean _canceled = false;

    public DateChooserDialog(Frame parent) {
        this(parent, Calendar.getInstance(), true);
    }

    public DateChooserDialog(Frame parent, Calendar cal, boolean controlPane) {
        super(parent, true);
        this._dateChooserPanel = new DateChooserPanel(cal, controlPane);
        this.getContentPane().add((Component)this._dateChooserPanel, "Center");
        this.getContentPane().add((Component)this._makeButtonPanel(), "South");
        this.pack();
        Preferences.manageLocation((Component)this);
        this.setResizable(false);
    }

    public Date getDate() {
        return this._dateChooserPanel.getDate();
    }

    public void setDate(Date date) {
        this._dateChooserPanel.setDate(date);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected JPanel _makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this._canceled = false;
                DateChooserDialog.this.hide();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this._canceled = true;
                DateChooserDialog.this.hide();
            }
        });
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Test DateChooserDialog");
        JPanel panel = new JPanel();
        JButton dateButton = new JButton("Choose Date...");
        JButton exitButton = new JButton("Exit");
        f.getContentPane().add(panel);
        panel.add(dateButton);
        panel.add(exitButton);
        f.pack();
        f.setVisible(true);
        Calendar cal = Calendar.getInstance();
        final DateChooserDialog dialog = new DateChooserDialog((Frame)f, cal, true);
        dateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.show();
                if (!dialog.isCanceled()) {
                    System.out.println("Selected date: " + dialog.getDate());
                }
            }
        });
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }
}

