/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jsky.coords.SiteDesc;
import jsky.coords.TargetDesc;
import jsky.plot.ElevationPlotUtil;
import jsky.plot.SunRiseSet;
import jsky.util.CalendarUtil;
import jsky.util.Preferences;
import jsky.util.StringUtil;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ElevationPlotModel {
    public static final int HOURS_TO_MILLISEC = 3600000;
    public static final String LST = "LST";
    public static final String UT = "UT";
    public static final String SITE_TIME = "Site Time";
    static final String SITE_PREF_KEY = ElevationPlotModel.class.getName() + ".site";
    static final String TIMEZONE_DISPLAY_NAME_PREF_KEY = ElevationPlotModel.class.getName() + ".timeZoneDisplayName";
    static final String TIMEZONE_ID_PREF_KEY = ElevationPlotModel.class.getName() + ".timeZoneId";
    private SiteDesc _site;
    private Date _startDate;
    private Date _endDate;
    private TargetDesc[] _targets;
    private Date[][] _xDate;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("HH:mm:ss");
    private double[][] _yData;
    private double[][] _yDataAirmass;
    private double[][] _yDataPa;
    private double[] _maxElevation;
    private double[] _maxElevationTime;
    private String _timeZoneDisplayName = "UT";
    private String _timeZoneId = "UT";
    private TimeZone _timeZone = TimeZone.getTimeZone("UT");
    private EventListenerList _listenerList = new EventListenerList();
    private ElevationPlotTableModel[] _tableModels;
    private static double _obsThreshold = 30.0;
    private ElevationPlotUtil _plotUtil;
    private SunRiseSet _sunRiseSet;

    public ElevationPlotModel(SiteDesc site, Date date, TargetDesc[] targets, String timeZoneDisplayName, String timeZoneId) {
        this._setSite(site);
        this._setDate(date);
        this._setTargets(targets);
        this._setTimeZone(timeZoneDisplayName, timeZoneId);
        this._updateModel();
    }

    public ElevationPlotModel(SiteDesc site, Date date, TargetDesc[] targets) {
        this(site, date, targets, UT, UT);
    }

    public void setSampleInterval(int minutes) {
        ElevationPlotUtil.setDefaultNumSteps(1440 / minutes);
        this._updateModel();
        this._fireChangeEvent();
    }

    public String getTitle() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy MMM d");
        return this._site.getName() + ": Night of " + dateFormat.format(this._startDate) + " ---> " + dateFormat.format(this._endDate);
    }

    public static double getObsThreshold() {
        return _obsThreshold;
    }

    public static void setObsThreshold(double d) {
        _obsThreshold = d;
    }

    private void _updateModel() {
        int i;
        this._plotUtil = new ElevationPlotUtil(this._startDate, this._site, this._targets);
        int numSteps = this._plotUtil.getNumSteps();
        this._maxElevation = new double[this._targets.length];
        this._maxElevationTime = new double[this._targets.length];
        this._tableModels = new ElevationPlotTableModel[this._targets.length];
        for (i = 0; i < this._targets.length; ++i) {
            this._tableModels[i] = new ElevationPlotTableModel(i);
        }
        this._sunRiseSet = new SunRiseSet(this._startDate, this._site);
        this._xDate = this._plotUtil.getXData();
        this._yData = this._plotUtil.getYData();
        this._yDataAirmass = this._plotUtil.getYDataAirmass();
        this._yDataPa = this._plotUtil.getYDataPa();
        for (i = 0; i < this._targets.length; ++i) {
            double[] el = this._yData[i];
            this._maxElevation[i] = -99.0;
            this._maxElevationTime[i] = 0.0;
            for (int j = 0; j < numSteps; ++j) {
                if (!(el[j] > this._maxElevation[i])) continue;
                this._maxElevation[i] = el[j];
                this._maxElevationTime[i] = this._xDate[i][j].getTime();
            }
        }
    }

    public SiteDesc getSite() {
        return this._site;
    }

    public void setSite(SiteDesc site) {
        this._setSite(site);
        if (this._timeZoneId.equals(SITE_TIME)) {
            this._setTimeZone(site.getTimeZone().getDisplayName(), SITE_TIME);
        }
        this._setDate(this._startDate);
        this._updateModel();
        this._fireChangeEvent();
    }

    private void _setSite(SiteDesc site) {
        this._site = site;
        Preferences.set((String)SITE_PREF_KEY, (String)this._site.getName());
    }

    public String getTimeZoneDisplayName() {
        return this._timeZoneDisplayName;
    }

    public String getTimeZoneId() {
        return this._timeZoneId;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(String timeZoneDisplayName, String timeZoneId) {
        this._setTimeZone(timeZoneDisplayName, timeZoneId);
        this._fireChangeEvent();
    }

    private void _setTimeZone(String timeZoneDisplayName, String timeZoneId) {
        this._timeZoneDisplayName = timeZoneDisplayName;
        this._timeZoneId = timeZoneId;
        Preferences.set((String)TIMEZONE_DISPLAY_NAME_PREF_KEY, (String)this._timeZoneDisplayName);
        Preferences.set((String)TIMEZONE_ID_PREF_KEY, (String)this._timeZoneId);
        this._timeZone = ElevationPlotUtil.UT;
        if (!this._timeZoneId.equals(LST) && !this._timeZoneId.equals(UT)) {
            this._timeZone = this._site.getTimeZone();
        }
        this._dateFormat.setTimeZone(this._timeZone);
    }

    public Date getDate() {
        return this._startDate;
    }

    public void setDate(Date date) {
        this._setDate(date);
        this._updateModel();
        this._fireChangeEvent();
    }

    private void _setDate(Date date) {
        Calendar cal = Calendar.getInstance(this._site.getTimeZone());
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        this._startDate = cal.getTime();
        cal.add(11, 24);
        this._endDate = cal.getTime();
    }

    private void _fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
        for (ElevationPlotTableModel _tableModel : this._tableModels) {
            _tableModel.fireTableModelEvent();
        }
    }

    public int getNumTargets() {
        if (this._targets == null) {
            return 0;
        }
        return this._targets.length;
    }

    public TargetDesc[] getTargets() {
        return this._targets;
    }

    public void setTargets(TargetDesc[] targets) {
        this._setTargets(targets);
        this._updateModel();
        this._fireChangeEvent();
    }

    private void _setTargets(TargetDesc[] targets) {
        this._targets = targets;
    }

    public TableModel getTableModel(int targetIndex) {
        return this._tableModels[targetIndex];
    }

    public XYDataset getXYDataset() {
        TimeSeriesCollection tsc = new TimeSeriesCollection(this._timeZone);
        int numSteps = this._plotUtil.getNumSteps();
        for (int i = 0; i < this._targets.length; ++i) {
            TimeSeries ts = new TimeSeries((Comparable)((Object)this._targets[i].getName()), Second.class);
            Date[] times = this._xDate[i];
            double[] elevations = this._yData[i];
            for (int j = 0; j < numSteps; ++j) {
                ts.add((RegularTimePeriod)new Second(times[j], this._timeZone), elevations[j]);
            }
            tsc.addSeries(ts);
        }
        return tsc;
    }

    public XYDataset getSecondaryDataset() {
        TimeSeriesCollection tsc = new TimeSeriesCollection(this._timeZone);
        int numSteps = this._plotUtil.getNumSteps();
        for (int i = 0; i < this._targets.length; ++i) {
            TimeSeries ts = new TimeSeries((Comparable)((Object)this._targets[i].getName()), Second.class);
            Date[] times = this._xDate[i];
            double[] pa = this._yDataPa[i];
            for (int j = 0; j < numSteps; ++j) {
                ts.add((RegularTimePeriod)new Second(times[j], this._timeZone), pa[j]);
            }
            tsc.addSeries(ts);
        }
        return tsc;
    }

    public double getMaxElevation(int targetIndex) {
        return this._maxElevation[targetIndex];
    }

    public double getMaxElevationTime(int targetIndex) {
        return this._maxElevationTime[targetIndex];
    }

    public String[] getCategories() {
        TreeSet<String> set = new TreeSet<String>();
        for (TargetDesc _target : this._targets) {
            set.add(_target.getCategory());
        }
        String[] result = new String[set.size()];
        set.toArray(result);
        return result;
    }

    public IntervalCategoryDataset getIntervalCategoryDataset(String category) {
        TaskSeriesCollection collection = new TaskSeriesCollection();
        TaskSeries taskSeries = new TaskSeries("Targets");
        int[] maxWidths = this._calculateTargetDescriptionColumnWidths(this._targets);
        int totalWidth = 0;
        for (int maxWidth : maxWidths) {
            totalWidth += maxWidth;
        }
        for (int i = 0; i < this._targets.length; ++i) {
            Task task;
            if (!this._targets[i].getCategory().equals(category)) continue;
            String name = this._getTargetDescription(this._targets[i], maxWidths, totalWidth);
            Date[] times = this._xDate[i];
            double[] elevations = this._yData[i];
            Date[] xTimes = this._findCrossingPoints(times, elevations);
            if (xTimes.length == 2) {
                task = new Task(name, (TimePeriod)new SimpleTimePeriod(xTimes[0], xTimes[1]));
                taskSeries.add(task);
                continue;
            }
            task = new Task(name, (TimePeriod)new SimpleTimePeriod(xTimes[0], xTimes[xTimes.length - 1]));
            int n = xTimes.length / 2;
            for (int j = 0; j < n; ++j) {
                Task subtask = new Task(name, (TimePeriod)new SimpleTimePeriod(xTimes[j * 2], xTimes[j * 2 + 1]));
                task.addSubtask(subtask);
            }
            taskSeries.add(task);
        }
        collection.add(taskSeries);
        return collection;
    }

    private int[] _calculateTargetDescriptionColumnWidths(TargetDesc[] targets) {
        String[] ar = targets[0].getDescriptionFields();
        int numDesc = ar.length;
        int[] maxWidths = new int[numDesc];
        for (int j = 0; j < numDesc; ++j) {
            maxWidths[j] = ar[j].length();
        }
        for (int i = 1; i < targets.length; ++i) {
            ar = targets[i].getDescriptionFields();
            for (int j = 0; j < numDesc; ++j) {
                if (ar[j].length() <= maxWidths[j]) continue;
                maxWidths[j] = ar[j].length();
            }
        }
        return maxWidths;
    }

    private String _getTargetDescription(TargetDesc target, int[] maxWidths, int totalWidth) {
        String[] ar = target.getDescriptionFields();
        StringBuilder sb = new StringBuilder(totalWidth);
        for (int i = 0; i < maxWidths.length; ++i) {
            sb.append(StringUtil.pad((String)ar[i], (int)maxWidths[i], (boolean)true));
            if (i == maxWidths.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public Date getLst(Date date) {
        return this._plotUtil.getLst(date);
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getDateForHour(double hour) {
        Calendar cal = Calendar.getInstance(ElevationPlotUtil.UT);
        cal.setTime(this._startDate);
        int h = cal.get(11);
        boolean nextDay = hour < (double)h;
        CalendarUtil.setHours(cal, hour, nextDay);
        return cal.getTime();
    }

    public Date getSunset() {
        return this._sunRiseSet.getSunset();
    }

    public Date getSunrise() {
        return this._sunRiseSet.getSunrise();
    }

    public Date getNauticalTwilightStart() {
        return this._sunRiseSet.getNauticalTwilightStart();
    }

    public Date getNauticalTwilightEnd() {
        return this._sunRiseSet.getNauticalTwilightEnd();
    }

    public Date getAstronomicalTwilightStart() {
        return this._sunRiseSet.getAstronomicalTwilightStart();
    }

    public Date getAstronomicalTwilightEnd() {
        return this._sunRiseSet.getAstronomicalTwilightEnd();
    }

    private int _getOffset(Date[] ar) {
        Date val = ar[0];
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i].compareTo(val) < 0) {
                return i;
            }
            val = ar[i];
        }
        return 0;
    }

    private Date[] _findCrossingPoints(Date[] times, double[] elevations) {
        Date[] ar;
        int offset = this._getOffset(times);
        ArrayList<Date> l = new ArrayList<Date>();
        boolean started = false;
        double val = elevations[offset];
        if (val > _obsThreshold) {
            l.add(times[offset]);
            started = true;
        }
        int n = elevations.length - 1;
        for (int i = 1; i < n; ++i) {
            int index = (offset + i) % elevations.length;
            val = elevations[index];
            if (!started && val > _obsThreshold) {
                l.add(times[index]);
                started = true;
                continue;
            }
            if (!started || !(val <= _obsThreshold)) continue;
            l.add(times[index]);
            started = false;
        }
        if (started) {
            l.add(times[(offset + n) % elevations.length]);
        }
        if (l.size() != 0) {
            ar = new Date[l.size()];
            l.toArray(ar);
        } else {
            ar = new Date[2];
            ar[0] = ar[1] = times[0];
        }
        return ar;
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    private class ElevationPlotTableModel
    implements TableModel {
        private int _targetIndex;
        private EventListenerList _tableListenerList = new EventListenerList();

        public ElevationPlotTableModel(int targetIndex) {
            this._targetIndex = targetIndex;
        }

        @Override
        public int getRowCount() {
            if (ElevationPlotModel.this._xDate == null) {
                return 0;
            }
            return ElevationPlotModel.this._xDate[this._targetIndex].length;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Time (hours)";
                }
                case 1: {
                    return "Elevation (degrees)";
                }
                case 2: {
                    return "Airmass";
                }
                case 3: {
                    return "Parallactic Angle";
                }
            }
            throw new IndexOutOfBoundsException("columnIndex");
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Double.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Date date = ElevationPlotModel.this._xDate[this._targetIndex][rowIndex];
                    if (ElevationPlotModel.this._timeZoneId.equals(ElevationPlotModel.LST)) {
                        date = ElevationPlotModel.this._plotUtil.getLst(date);
                    }
                    return ElevationPlotModel.this._dateFormat.format(date);
                }
                case 1: {
                    return new Double(ElevationPlotModel.this._yData[this._targetIndex][rowIndex]);
                }
                case 2: {
                    return new Double(ElevationPlotModel.this._yDataAirmass[this._targetIndex][rowIndex]);
                }
                case 3: {
                    return new Double(ElevationPlotModel.this._yDataPa[this._targetIndex][rowIndex]);
                }
            }
            throw new IndexOutOfBoundsException("columnIndex");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void fireTableModelEvent() {
            TableModelEvent changeEvent = new TableModelEvent(this);
            Object[] listeners = this._tableListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                ((TableModelListener)listeners[i + 1]).tableChanged(changeEvent);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this._tableListenerList.add(TableModelListener.class, l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._tableListenerList.remove(TableModelListener.class, l);
        }
    }
}

