/*
 * Decompiled with CFR 0.152.
 */
package alma.hibernate.util;

import alma.hibernate.util.JdbcNativeExtractor;
import com.mchange.v2.c3p0.impl.C3P0ResultSetPeeker;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class HibernateXmlType
implements UserType<String>,
Serializable {
    private static final long serialVersionUID = -3359971984030700151L;
    private static final String COM_MCHANGE_V2_C3P0 = "com.mchange.v2.c3p0";
    private static final String ORACLE_JDBC = "oracle.jdbc";
    private static final String GET_STRING_VAL = "getStringVal";
    private static final String XML_TYPE = "oracle.xdb.XMLType";
    private static final int SQL_TYPE = 2007;

    public String nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor si, Object owner) throws HibernateException, SQLException {
        if (rs.getClass().getName().startsWith(COM_MCHANGE_V2_C3P0)) {
            rs = C3P0ResultSetPeeker.getInnerFrom(rs);
        }
        if (rs.getClass().getName().startsWith(ORACLE_JDBC)) {
            String string;
            Object xmlType = null;
            try {
                Class<?> clazz = Class.forName(XML_TYPE);
                Method m = clazz.getMethod(GET_STRING_VAL, new Class[0]);
                xmlType = rs.getObject(position);
                string = xmlType != null ? (String)m.invoke(xmlType, new Object[0]) : null;
            }
            catch (Exception e) {
                try {
                    throw new SQLException("Failed to convert XMLTYPE String to Document for retrieval", e);
                }
                catch (Throwable throwable) {
                    this.close(xmlType);
                    throw throwable;
                }
            }
            this.close(xmlType);
            return string;
        }
        return this.nonOracleNullSafeGet(rs, position, si, owner);
    }

    private void close(Object xmlType) throws SQLException {
        if (xmlType != null) {
            try {
                Class<?> clazz = Class.forName(XML_TYPE);
                Method m = clazz.getMethod("close", new Class[0]);
                m.invoke(xmlType, new Object[0]);
            }
            catch (Exception e) {
                throw new SQLException("Error while closing XMLTYPE", e);
            }
        }
    }

    private String nonOracleNullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Reader reader = rs.getCharacterStream(position);
        if (reader == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(4096);
        try {
            char[] charbuf = new char[4096];
            int i = reader.read(charbuf);
            while (i > 0) {
                result.append(charbuf, 0, i);
                i = reader.read(charbuf);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return result.toString();
    }

    public void nullSafeSet(PreparedStatement st, String value, int index, SharedSessionContractImplementor si) throws HibernateException, SQLException {
        JdbcNativeExtractor extractor = new JdbcNativeExtractor();
        Connection connection = extractor.getNativeConnection(st.getConnection());
        if (connection.getClass().getName().startsWith(ORACLE_JDBC)) {
            Object xmlType = null;
            try {
                if (value != null) {
                    Class<?> clazz = Class.forName(XML_TYPE);
                    Constructor<?> con = clazz.getConstructor(Connection.class, String.class);
                    xmlType = con.newInstance(connection, value);
                    st.setObject(index, xmlType);
                }
                st.setNull(index, 2007, "SYS.XMLTYPE");
            }
            catch (Exception e) {
                throw new SQLException("Failed to convert Document to XMLTYPE String for storage", e);
            }
            finally {
                this.close(xmlType);
            }
        } else {
            this.nonOracleNullSafeSet(st, value, index, si);
        }
    }

    private void nonOracleNullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value != null) {
            String string = (String)value;
            StringReader reader = new StringReader(string);
            st.setCharacterStream(index, (Reader)reader, string.length());
        } else {
            st.setNull(index, this.getSqlType());
        }
    }

    public int getSqlType() {
        return 2007;
    }

    public Class<String> returnedClass() {
        return String.class;
    }

    public boolean equals(String x, String y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null && y != null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(String x) throws HibernateException {
        return x.hashCode();
    }

    public String deepCopy(String value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(String value) throws HibernateException {
        try {
            return value;
        }
        catch (Exception e) {
            throw new HibernateException("Could not disassemble Document to Serializable", (Throwable)e);
        }
    }

    public String assemble(Serializable cached, Object owner) throws HibernateException {
        try {
            return (String)((Object)cached);
        }
        catch (Exception e) {
            throw new HibernateException("Could not assemble String to Document", (Throwable)e);
        }
    }

    public String replace(String original, String target, Object owner) throws HibernateException {
        return original;
    }
}

