/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.vmtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SysPropEditor
extends JPanel {
    protected MapTableModel model = new MapTableModel(new String[]{"name", "value"});

    public static void main(String[] args) {
        SysPropEditor inst = new SysPropEditor();
        SysPropEditor.openFrame(inst);
    }

    public static JFrame openFrame(SysPropEditor inst) {
        final JFrame f = new JFrame(SysPropEditor.class.getName());
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                int answer = JOptionPane.showConfirmDialog(f, "Really close?", "Close Window", 0);
                if (answer == 0) {
                    f.setVisible(false);
                    f.dispose();
                }
            }
        });
        f.getContentPane().add(inst);
        f.pack();
        f.setVisible(true);
        return f;
    }

    public SysPropEditor() {
        super(new BorderLayout());
        this.populateModel(new String[0]);
        this.model.addTableModelListener(new MyTableModelListener(this));
        JTable table = new JTable(this.model);
        this.add((Component)new JScrollPane(table), "Center");
        this.add((Component)new Controls(), "South");
    }

    public void populateModel(String[] nameFilter) {
        Properties m = System.getProperties();
        ArrayList<String> names = new ArrayList<String>(m.size());
        Enumeration<?> en = m.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!this.passesThroughFilter(nameFilter, name)) continue;
            names.add(name);
        }
        Collections.sort(names);
        Object[][] data = new String[names.size()][2];
        Iterator it = names.iterator();
        int i = 0;
        while (it.hasNext()) {
            String name = (String)it.next();
            data[i][0] = name;
            data[i][1] = m.getProperty(name);
            ++i;
        }
        this.model.setData(data);
    }

    private boolean passesThroughFilter(String[] nameFilter, String name) {
        for (int i = 0; i < nameFilter.length; ++i) {
            if (!name.startsWith(nameFilter[i])) continue;
            return false;
        }
        return true;
    }

    public class MapTableModel
    extends AbstractTableModel {
        protected String[] columnNames;
        protected Object[][] data;

        public MapTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public void setData(Object[][] data) {
            this.data = data;
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.data[row][column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            String cellValue = value.toString();
            this.data[row][column] = cellValue;
            this.fireTableCellUpdated(row, column);
        }
    }

    class MyTableModelListener
    implements TableModelListener {
        MyTableModelListener(SysPropEditor this$0) {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0 && e.getFirstRow() == e.getLastRow()) {
                TableModel src = (TableModel)e.getSource();
                int row = e.getFirstRow();
                String name = (String)src.getValueAt(row, 0);
                String value = (String)src.getValueAt(row, 1);
                System.setProperty(name, value);
            }
        }
    }

    class Controls
    extends JPanel {
        JTextField txtNameFilter;

        Controls() {
            super(new BorderLayout());
            this.add((Component)new JLabel("Don't show: "), "West");
            this.txtNameFilter = new JTextField();
            this.add((Component)this.txtNameFilter, "Center");
            JButton r = new JButton("Refresh");
            r.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StringTokenizer t = new StringTokenizer(Controls.this.txtNameFilter.getText(), ";, ", false);
                    String[] nameFilter = Collections.list(t).toArray(new String[0]);
                    SysPropEditor.this.populateModel(nameFilter);
                }
            });
            this.add((Component)r, "East");
            this.txtNameFilter.setText("sun, awt, file, os, java.awt, java.vm, java.vendor, java.spec");
        }
    }
}

