/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ProcessStreamGobbler {
    private final Process proc;
    private final List<String> stdout;
    private final List<String> stderr;
    private final ThreadFactory tf;
    private GobblerRunnable runErr;
    private GobblerRunnable runOut;
    private volatile boolean DEBUG = false;

    public ProcessStreamGobbler(Process proc, ThreadFactory tf, boolean storeStreamContent) {
        this.proc = proc;
        this.tf = tf;
        if (storeStreamContent) {
            this.stdout = new ArrayList<String>();
            this.stderr = new ArrayList<String>();
        } else {
            this.stdout = null;
            this.stderr = null;
        }
    }

    public void gobbleAsync() {
        try {
            this.gobble(-1L, null);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public boolean gobble(long timeout, TimeUnit unit) throws InterruptedException {
        ThreadPoolExecutor exsrv = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.tf);
        this.runOut = new GobblerRunnable(this.proc.getInputStream(), this.stdout, "stdout", this.DEBUG);
        exsrv.submit(this.runOut);
        this.runErr = new GobblerRunnable(this.proc.getErrorStream(), this.stderr, "stderr", this.DEBUG);
        exsrv.submit(this.runErr);
        if (timeout > 0L) {
            exsrv.shutdown();
            return exsrv.awaitTermination(timeout, unit);
        }
        return false;
    }

    public List<String> getStdout() {
        return this.stdout;
    }

    public List<String> getStderr() {
        return this.stderr;
    }

    public boolean hasStreamReadErrors() {
        if (this.runOut == null || this.runErr == null) {
            throw new IllegalStateException("Cannot call this method before gobbling.");
        }
        return this.runOut.hasReadError | this.runErr.hasReadError;
    }

    public boolean hasTerminated() {
        if (this.runOut == null || this.runErr == null) {
            throw new IllegalStateException("Cannot call this method before gobbling.");
        }
        return this.runOut.hasTerminated | this.runErr.hasTerminated;
    }

    public void setDebug(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    private static class GobblerRunnable
    implements Runnable {
        private final BufferedReader br;
        private final List<String> buffer;
        private boolean hasReadError;
        private boolean hasTerminated;
        private String name;
        private final boolean DEBUG;

        GobblerRunnable(InputStream stream, List<String> buffer, String name, boolean DEBUG) {
            this.br = new BufferedReader(new InputStreamReader(stream));
            this.buffer = buffer;
            this.hasReadError = false;
            this.hasTerminated = false;
            this.name = name;
            this.DEBUG = DEBUG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.br.readLine()) != null) {
                    if (this.DEBUG) {
                        System.out.println(this.name + ": " + line);
                    }
                    if (this.buffer == null) continue;
                    this.buffer.add(line);
                }
                if (!this.DEBUG) return;
                System.out.println(this.name + ": done reading");
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.hasReadError = true;
                return;
            }
            finally {
                try {
                    this.br.close();
                    if (this.DEBUG) {
                        System.out.println(this.name + ": streams closed.");
                    }
                }
                catch (IOException ex) {
                    if (this.DEBUG) {
                        System.out.println(this.name + ": streams failed to close.");
                    }
                }
                finally {
                    this.hasTerminated = true;
                }
            }
        }
    }
}

