/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.testsupport;

import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.util.ProcessStreamGobbler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ProcessUtil {
    private final Logger logger;
    private volatile boolean DEBUG = false;

    public ProcessUtil(Logger logger) {
        this.logger = logger;
    }

    public List<String> getJavaPIDs(Class<?> mainClass) throws IOException {
        Map<String, List<String>> pidMap = this.getJavaPIDs();
        List<String> pidList = pidMap.get(mainClass.getName());
        if (pidList == null) {
            pidList = new ArrayList<String>();
        }
        return pidList;
    }

    public boolean isJavaProcessRunning(Class<?> mainClass) throws IOException {
        return this.getJavaPIDs(mainClass).size() > 0;
    }

    public int killProcess(String pid, boolean tough) throws IOException, InterruptedException {
        Object command = "kill ";
        if (tough) {
            command = (String)command + "-9 ";
        }
        command = (String)command + pid;
        this.logger.info("Will kill process " + pid + " using command '" + (String)command + "'.");
        Process killProc = Runtime.getRuntime().exec((String)command);
        return killProc.waitFor();
    }

    protected Map<String, List<String>> getJavaPIDs() throws IOException {
        String command = "jps -l";
        Process proc = Runtime.getRuntime().exec(command);
        ProcessStreamGobbler gob = new ProcessStreamGobbler(proc, new DaemonThreadFactory(), true);
        gob.setDebug(this.DEBUG);
        try {
            if (!gob.gobble(10L, TimeUnit.SECONDS)) {
                throw new IOException("Failed to execute command '" + command + "' within 10 seconds");
            }
            if (gob.hasStreamReadErrors()) {
                throw new IOException("Failed to read output of command '" + command + "'");
            }
        }
        catch (InterruptedException ex) {
            throw new IOException("Thread reading output of command '" + command + "' got interrupted.");
        }
        HashMap<String, List<String>> pidMap = new HashMap<String, List<String>>();
        List<String> outlines = gob.getStdout();
        String[] splitLine = null;
        for (String line : outlines) {
            if (line.length() > 0 && (splitLine = line.split(" ")).length == 2) {
                String cname = splitLine[1];
                if ("sun.tools.jps.Jps".equals(cname)) continue;
                String pid = splitLine[0];
                List<String> pidList = pidMap.containsKey(cname) ? (List)pidMap.get(cname) : new ArrayList();
                pidList.add(pid);
                pidMap.put(cname, pidList);
                continue;
            }
            this.logger.info("jps returned unexpected line '" + line + "'");
        }
        return pidMap;
    }

    public void setDebug(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }
}

