/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.makesupport;

import alma.acs.makesupport.AcsJarFileFinder;
import alma.acs.makesupport.JarSourceExtractor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class JarSourceExtractorRunner {
    public static final String PROPERTY_EXTRACT_ONLY_GENERATED_JARS = "jarExtract.onlyGeneratedJars";
    public static final String Manifest_Attr_ACSGeneratedFromFile = "ACS-Generated-FromFile";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block12: {
            if (args.length < 2) {
                System.err.println("usage: " + JarSourceExtractorRunner.class.getName() + " outputJarFile jarDirectory1 jarDirectory2 ...");
                return;
            }
            try {
                Logger logger = Logger.getLogger("ACS.JarSourceExtractorRunner");
                File targetJarFile = new File(args[0]);
                if (targetJarFile.exists()) {
                    targetJarFile.delete();
                } else {
                    File parent = targetJarFile.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                }
                targetJarFile.createNewFile();
                if (!targetJarFile.isFile() || !targetJarFile.canWrite()) {
                    throw new IOException(targetJarFile + " is not a writable file.");
                }
                File[] dirs = JarSourceExtractorRunner.getDirectories(args);
                AcsJarFileFinder jarFinder = new AcsJarFileFinder(dirs, logger);
                File[] jarFiles = jarFinder.getAllFiles();
                if (jarFiles.length > 0) {
                    JarSourceExtractor extractor = new JarSourceExtractor();
                    FileOutputStream out = new FileOutputStream(targetJarFile);
                    JarOutputStream jarOut = new JarOutputStream(out);
                    try {
                        for (int i = 0; i < jarFiles.length; ++i) {
                            JarFile jarFile = new JarFile(jarFiles[i]);
                            if (!JarSourceExtractorRunner.needsProcessing(jarFile)) continue;
                            extractor.extractJavaSourcesToJar(jarFile, jarOut);
                        }
                        break block12;
                    }
                    finally {
                        jarOut.finish();
                        jarOut.close();
                    }
                }
                System.out.println("no jar files found.");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    static boolean needsProcessing(JarFile jarFile) throws IOException {
        Manifest mani;
        boolean needed;
        boolean onlyGeneratedJars = Boolean.getBoolean(PROPERTY_EXTRACT_ONLY_GENERATED_JARS);
        boolean bl = needed = !onlyGeneratedJars;
        if (!needed && (mani = jarFile.getManifest()) != null) {
            Map<String, Attributes> entries = mani.getEntries();
            Attributes mainAttrs = mani.getMainAttributes();
            Iterator<Object> mainAttrIter = mainAttrs.keySet().iterator();
            while (mainAttrIter.hasNext()) {
                String attr = ((Attributes.Name)mainAttrIter.next()).toString();
                String value = mainAttrs.getValue(attr);
                if (!attr.equals(Manifest_Attr_ACSGeneratedFromFile)) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    static File[] getDirectories(String[] mainArgs) {
        ArrayList<File> dirList = new ArrayList<File>();
        for (int i = 1; i < mainArgs.length; ++i) {
            File jarDir = new File(mainArgs[i]);
            if (jarDir.exists() && jarDir.isDirectory()) {
                dirList.add(jarDir);
                continue;
            }
            System.err.println("ignoring invalid directory " + jarDir.getAbsolutePath());
        }
        return dirList.toArray(new File[dirList.size()]);
    }
}

