/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.makesupport;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class AbstractJarEntryExtractor {
    public static final String[] PREFIX_PATHS = new String[]{"src", "test"};
    public final String FILETYPE;

    public AbstractJarEntryExtractor(String filetype) {
        this.FILETYPE = filetype;
    }

    protected String getClassName(JarEntry javaEntry) {
        String className = javaEntry.getName();
        for (int j = 0; j < PREFIX_PATHS.length; ++j) {
            if (!className.startsWith(PREFIX_PATHS[j])) continue;
            className = className.substring(PREFIX_PATHS[j].length());
            break;
        }
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        return className;
    }

    public JarEntry[] getJavaEntries(JarFile jarfile) {
        ArrayList<JarEntry> javaEntries = new ArrayList<JarEntry>();
        Enumeration<JarEntry> jarEntries = jarfile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            if (!entry.getName().endsWith(this.FILETYPE)) continue;
            javaEntries.add(entry);
        }
        return javaEntries.toArray(new JarEntry[javaEntries.size()]);
    }
}

