/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.config.validators;

import alma.acs.config.validators.ConfigFileRedeemer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ConfigFileRedeemerFilepath
extends ConfigFileRedeemer {
    private List<String> redeemedFilePathSnippets;
    private String baseDirPath;

    public ConfigFileRedeemerFilepath(Logger logger, File baseDir) {
        super(logger);
        this.baseDirPath = baseDir.getAbsolutePath();
        this.redeemedFilePathSnippets = new ArrayList<String>();
        this.configure();
    }

    @Override
    protected boolean _isNotAConfigFile(File file) {
        String relPathName = file.getAbsolutePath();
        if (!relPathName.startsWith(this.baseDirPath)) {
            this.logger.warning("File '" + file.getAbsolutePath() + "' does not lie under base dir " + this.baseDirPath);
            return false;
        }
        relPathName = relPathName.substring(this.baseDirPath.length() + 1);
        if (File.separatorChar != '/') {
            relPathName = relPathName.replace(File.separatorChar, '/');
        }
        for (String snippet : this.redeemedFilePathSnippets) {
            boolean snippetAtStart = false;
            if (snippet.charAt(0) == '^') {
                snippetAtStart = true;
                snippet = snippet.substring(1);
            }
            if ((!snippetAtStart || !relPathName.startsWith(snippet)) && (snippetAtStart || relPathName.indexOf(snippet) <= 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getFileEndings() {
        return null;
    }

    public void addRedeemedFilePathSnippet(String filePathSnippet) {
        if (filePathSnippet != null) {
            this.redeemedFilePathSnippets.add(filePathSnippet);
        }
    }

    public void configure() {
        String[] snippets = new String[]{"^ACS/LGPL/Tools", "^ACS/LGPL/CommonSoftware/acscourse", "^ITS", "^ITS.old", "^OBSPREP/ObservingTool/idl/ObsToolUserPrefs.xsd"};
        for (int i = 0; i < snippets.length; ++i) {
            this.addRedeemedFilePathSnippet(snippets[i]);
        }
    }
}

