/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.concurrent;

import alma.acs.concurrent.NamedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadLoopRunner {
    private final Logger logger;
    private final ScheduledExecutorService runner;
    private final TaskWrapper taskWrapper;
    private volatile ScheduleDelayMode delayMode;
    private volatile long delayTimeNanos;
    private volatile ScheduledFuture<?> loop;
    private final AtomicBoolean isDefunct;
    private final ReentrantLock loopLock = new ReentrantLock();
    private final String loopName;

    public ThreadLoopRunner(Runnable task, long delayTime, TimeUnit unit, ThreadFactory tf, Logger logger, String name) {
        this.logger = logger;
        this.loopName = name != null && !name.trim().isEmpty() ? name.trim() : null;
        this.runner = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(tf, this.loopName));
        this.taskWrapper = new TaskWrapper(task, this.loopLock, logger);
        this.delayMode = ScheduleDelayMode.FIXED_RATE;
        this.isDefunct = new AtomicBoolean(false);
        this.setDelayTime(delayTime, unit);
    }

    public long getDelayTimeMillis() {
        return TimeUnit.MILLISECONDS.convert(this.delayTimeNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelayTime(long delayTime, TimeUnit unit) {
        if (this.isDefunct.get()) {
            throw new IllegalStateException("[" + this.loopName + "] already disabled");
        }
        this.loopLock.lock();
        try {
            this.delayTimeNanos = TimeUnit.NANOSECONDS.convert(delayTime, unit);
            if (this.isLoopRunning()) {
                this.suspendLoop();
                if (this.isTaskRunning()) {
                    this.taskWrapper.restartLoopAfterCurrentTaskFinished(new Runnable(){

                        @Override
                        public void run() {
                            ThreadLoopRunner.this.logger.finer("[" + ThreadLoopRunner.this.loopName + "] will restart the loop now, which was stopped to change the delay time.");
                            ThreadLoopRunner.this.runLoop();
                        }
                    });
                } else {
                    this.runLoop();
                }
            }
        }
        finally {
            this.loopLock.unlock();
        }
    }

    public ScheduleDelayMode getDelayMode() {
        return this.delayMode;
    }

    public void setDelayMode(ScheduleDelayMode delayMode) {
        if (this.isDefunct.get()) {
            throw new IllegalStateException("[" + this.loopName + "] already disabled");
        }
        if (delayMode == null) {
            throw new IllegalArgumentException("delayMode must not be null");
        }
        if (this.isLoopRunning()) {
            throw new IllegalStateException("Cannot set delay mode while the loop is running");
        }
        this.delayMode = delayMode;
    }

    public void runLoop() {
        if (this.isDefunct.get()) {
            throw new IllegalStateException("[" + this.loopName + "] already disabled");
        }
        this.loopLock.lock();
        try {
            if (this.isLoopRunning()) {
                throw new IllegalStateException("Loop is already running");
            }
            if (this.isTaskRunning()) {
                throw new IllegalStateException("The task's run method is still being executed");
            }
            if (this.delayMode == ScheduleDelayMode.FIXED_RATE) {
                this.loop = this.runner.scheduleAtFixedRate(this.taskWrapper, 0L, this.delayTimeNanos, TimeUnit.NANOSECONDS);
                this.logger.finer("[" + this.loopName + "] started task loop with FIXED_RATE=" + TimeUnit.MILLISECONDS.convert(this.delayTimeNanos, TimeUnit.NANOSECONDS) + " ms.");
            } else {
                this.loop = this.runner.scheduleWithFixedDelay(this.taskWrapper, 0L, this.delayTimeNanos, TimeUnit.NANOSECONDS);
                this.logger.finer("[" + this.loopName + "] started task loop with FIXED_DELAY=" + TimeUnit.MILLISECONDS.convert(this.delayTimeNanos, TimeUnit.NANOSECONDS) + " ms.");
            }
        }
        finally {
            this.loopLock.unlock();
        }
    }

    public boolean isLoopRunning() {
        this.loopLock.lock();
        try {
            boolean bl = this.loop != null;
            return bl;
        }
        finally {
            this.loopLock.unlock();
        }
    }

    public boolean isTaskRunning() {
        return this.taskWrapper.isRunning();
    }

    public boolean isDisabled() {
        return this.isDefunct.get();
    }

    public void suspendLoop() {
        if (this.isDefunct.get()) {
            throw new IllegalStateException("[" + this.loopName + "] already disabled");
        }
        this.loopLock.lock();
        try {
            if (this.isLoopRunning()) {
                if (this.loop.cancel(false)) {
                    this.logger.finer("[" + this.loopName + "] suspended the task loop.");
                } else {
                    this.logger.fine("[" + this.loopName + "] failed to suspend the loop (without having attempted to cancel a running task, if any).");
                }
                this.loop = null;
                this.taskWrapper.restartLoopAfterCurrentTaskFinished(null);
            } else {
                this.logger.fine("[" + this.loopName + "] loop was not running, nothing to suspend.");
            }
        }
        finally {
            this.loopLock.unlock();
        }
    }

    public boolean suspendLoopAndWait(long timeout, TimeUnit unit) throws InterruptedException {
        this.suspendLoop();
        return this.taskWrapper.awaitTaskFinish(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        block5: {
            if (this.isDefunct.getAndSet(true)) {
                throw new IllegalStateException("[" + this.loopName + "] already disabled");
            }
            this.loopLock.lock();
            try {
                if (this.isLoopRunning()) {
                    this.loop.cancel(false);
                    this.loop = null;
                    this.taskWrapper.attemptCancelTask();
                    this.runner.shutdown();
                    this.logger.finest("[" + this.loopName + "] task loop has been shut down, will wait for it to fully terminate.");
                    break block5;
                }
                this.logger.finer("[" + this.loopName + "] nothing to shut down, task loop was not running.");
                boolean bl = true;
                return bl;
            }
            finally {
                this.loopLock.unlock();
            }
        }
        boolean ret = this.runner.awaitTermination(timeout, unit);
        this.logger.finer("[" + this.loopName + "] task " + (ret ? "finished" : "failed to finish") + " within the specified " + timeout + " " + unit.toString().toLowerCase());
        Thread.sleep(2L);
        return ret;
    }

    private static class TaskWrapper
    implements Runnable {
        private final Logger logger;
        private final Runnable delegate;
        private final ReentrantLock runLock;
        private final ReentrantLock loopLock;
        private volatile boolean isRunning;
        private volatile Runnable restartLoopRunnable;

        TaskWrapper(Runnable delegate, ReentrantLock loopLock, Logger logger) {
            this.logger = logger;
            this.delegate = delegate;
            this.runLock = new ReentrantLock();
            this.loopLock = loopLock;
            this.isRunning = false;
        }

        @Override
        public void run() {
            this.runLock.lock();
            try {
                this.isRunning = true;
                this.delegate.run();
            }
            catch (Throwable thr) {
                this.logger.log(Level.WARNING, "Uncaught error in scheduled Runnable.", thr);
            }
            finally {
                this.runLock.unlock();
                this.isRunning = false;
            }
            this.loopLock.lock();
            try {
                if (this.restartLoopRunnable != null) {
                    this.restartLoopRunnable.run();
                    this.restartLoopRunnable = null;
                }
            }
            finally {
                this.loopLock.unlock();
            }
        }

        boolean isRunning() {
            return this.isRunning;
        }

        void attemptCancelTask() {
            if (this.delegate instanceof CancelableRunnable) {
                ((CancelableRunnable)this.delegate).cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean awaitTaskFinish(long timeout, TimeUnit unit) throws InterruptedException {
            boolean gotIt = false;
            try {
                gotIt = this.runLock.tryLock(timeout, unit);
            }
            finally {
                if (gotIt) {
                    this.runLock.unlock();
                }
            }
            return gotIt;
        }

        void restartLoopAfterCurrentTaskFinished(Runnable restartLoopRunnable) {
            this.loopLock.lock();
            this.restartLoopRunnable = restartLoopRunnable;
            this.loopLock.unlock();
        }
    }

    public static enum ScheduleDelayMode {
        FIXED_RATE,
        FIXED_DELAY;

    }

    public static abstract class CancelableRunnable
    implements Runnable {
        protected volatile boolean shouldTerminate = false;

        public void cancel() {
            this.shouldTerminate = true;
        }
    }
}

