/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadBurstExecutorService {
    private final ThreadPoolExecutor delegate;
    private final CountDownLatch threadGate;
    private final AtomicBoolean executed;

    public ThreadBurstExecutorService(ThreadFactory threadFactory) {
        this.delegate = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        this.threadGate = new CountDownLatch(1);
        this.executed = new AtomicBoolean(false);
    }

    public <T> Future<T> submit(Callable<T> task, long awaitExecutionTimeout, TimeUnit unit) throws InterruptedException {
        if (this.executed.get()) {
            throw new IllegalStateException();
        }
        CountDownLatch confirmWaiting = new CountDownLatch(1);
        InterceptingCallable<T> interceptingCallable = new InterceptingCallable<T>(task, this.threadGate, confirmWaiting, awaitExecutionTimeout, unit);
        Future<T> future = this.delegate.submit(interceptingCallable);
        if (!confirmWaiting.await(awaitExecutionTimeout, unit)) {
            System.out.println("ThreadBurstExecutorService#submit: Starting of thread too slow!");
        }
        return future;
    }

    public Future<Void> submit(final Runnable task, long awaitExecutionTimeout, TimeUnit unit) throws InterruptedException {
        Callable<Void> adapter = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                task.run();
                return null;
            }
        };
        return this.submit(adapter, awaitExecutionTimeout, unit);
    }

    public boolean executeAllAndWait(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executed.getAndSet(true)) {
            throw new IllegalStateException();
        }
        this.threadGate.countDown();
        this.delegate.shutdown();
        return this.delegate.awaitTermination(timeout, unit);
    }

    public boolean terminateAllAndWait(long timeout, TimeUnit unit) throws InterruptedException {
        this.delegate.shutdownNow();
        return this.delegate.awaitTermination(timeout, unit);
    }

    private static class InterceptingCallable<V>
    implements Callable<V> {
        private final Callable<V> delegateCallable;
        private final CountDownLatch threadGate;
        private final CountDownLatch confirmWaiting;
        private final long awaitExecutionTimeout;
        private final TimeUnit unit;

        InterceptingCallable(Callable<V> delegate, CountDownLatch threadGate, CountDownLatch confirmWaiting, long awaitExecutionTimeout, TimeUnit unit) {
            this.delegateCallable = delegate;
            this.threadGate = threadGate;
            this.confirmWaiting = confirmWaiting;
            this.awaitExecutionTimeout = awaitExecutionTimeout;
            this.unit = unit;
        }

        @Override
        public V call() throws Exception {
            this.confirmWaiting.countDown();
            if (!this.threadGate.await(this.awaitExecutionTimeout, this.unit)) {
                String msg = "Timeout occured while waiting for thread gate to be opened.";
                System.out.println(msg);
                throw new TimeoutException(msg);
            }
            return this.delegateCallable.call();
        }
    }
}

