/*
 * Decompiled with CFR 0.152.
 */
package alma.Control;

import alma.AntennaMotionPatternMod.AntennaMotionPattern;
import alma.AntennaMotionPatternMod.AntennaMotionPatternHelper;
import alma.CalDataOriginMod.CalDataOrigin;
import alma.CalDataOriginMod.CalDataOriginHelper;
import alma.CalibrationFunctionMod.CalibrationFunction;
import alma.CalibrationFunctionMod.CalibrationFunctionHelper;
import alma.CalibrationSetMod.CalibrationSet;
import alma.CalibrationSetMod.CalibrationSetHelper;
import alma.Control.ScanIntentData;
import alma.ScanIntentMod.ScanIntent;
import alma.ScanIntentMod.ScanIntentHelper;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class ScanIntentDataHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<ScanIntentDataHelper> clazz = ScanIntentDataHelper.class;
        synchronized (ScanIntentDataHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(ScanIntentDataHelper.id(), "ScanIntentData", new StructMember[]{new StructMember("scanIntent", ScanIntentDataHelper.scanIntentFactory(), null), new StructMember("calDataOrig", ScanIntentDataHelper.calDataOrigFactory(), null), new StructMember("calSet", ScanIntentDataHelper.calSetFactory(), null), new StructMember("calFunction", ScanIntentDataHelper.calFunctionFactory(), null), new StructMember("antennaMotionPattern", ScanIntentDataHelper.antennaMotionPatternFactory(), null), new StructMember("onlineCalibration", ScanIntentDataHelper.onlineCalibrationFactory(), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    private static TypeCode scanIntentFactory() {
        return ORB.init().create_enum_tc(ScanIntentHelper.id(), "ScanIntent", new String[]{"CALIBRATE_AMPLI", "CALIBRATE_ATMOSPHERE", "CALIBRATE_BANDPASS", "CALIBRATE_DELAY", "CALIBRATE_FLUX", "CALIBRATE_FOCUS", "CALIBRATE_FOCUS_X", "CALIBRATE_FOCUS_Y", "CALIBRATE_PHASE", "CALIBRATE_POINTING", "CALIBRATE_POLARIZATION", "CALIBRATE_SIDEBAND_RATIO", "CALIBRATE_WVR", "DO_SKYDIP", "MAP_ANTENNA_SURFACE", "MAP_PRIMARY_BEAM", "OBSERVE_TARGET", "CALIBRATE_POL_LEAKAGE", "CALIBRATE_POL_ANGLE", "TEST", "UNSPECIFIED", "CALIBRATE_ANTENNA_POSITION", "CALIBRATE_ANTENNA_PHASE", "MEASURE_RFI", "CALIBRATE_ANTENNA_POINTING_MODEL", "SYSTEM_CONFIGURATION", "CALIBRATE_APPPHASE_ACTIVE", "CALIBRATE_APPPHASE_PASSIVE", "OBSERVE_CHECK_SOURCE", "CALIBRATE_DIFFGAIN"});
    }

    private static TypeCode antennaMotionPatternFactory() {
        return ORB.init().create_enum_tc(AntennaMotionPatternHelper.id(), "AntennaMotionPattern", new String[]{"NONE", "CROSS_SCAN", "SPIRAL", "CIRCLE", "THREE_POINTS", "FOUR_POINTS", "FIVE_POINTS", "TEST", "UNSPECIFIED", "STAR", "LISSAJOUS"});
    }

    private static TypeCode onlineCalibrationFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode calDataOrigFactory() {
        return ORB.init().create_enum_tc(CalDataOriginHelper.id(), "CalDataOrigin", new String[]{"TOTAL_POWER", "WVR", "CHANNEL_AVERAGE_AUTO", "CHANNEL_AVERAGE_CROSS", "FULL_RESOLUTION_AUTO", "FULL_RESOLUTION_CROSS", "OPTICAL_POINTING", "HOLOGRAPHY", "NONE"});
    }

    private static TypeCode calFunctionFactory() {
        return ORB.init().create_enum_tc(CalibrationFunctionHelper.id(), "CalibrationFunction", new String[]{"FIRST", "LAST", "UNSPECIFIED"});
    }

    private static TypeCode calSetFactory() {
        return ORB.init().create_enum_tc(CalibrationSetHelper.id(), "CalibrationSet", new String[]{"NONE", "AMPLI_CURVE", "ANTENNA_POSITIONS", "PHASE_CURVE", "POINTING_MODEL", "ACCUMULATE", "TEST", "UNSPECIFIED"});
    }

    public static void insert(Any any, ScanIntentData s) {
        any.type(ScanIntentDataHelper.type());
        ScanIntentDataHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanIntentData extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            ScanIntentData scanIntentData = ScanIntentDataHelper.read(in);
            return scanIntentData;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:alma/Control/ScanIntentData:1.0";
    }

    public static ScanIntentData read(InputStream in) {
        ScanIntentData result = new ScanIntentData();
        result.scanIntent = ScanIntentHelper.read((InputStream)in);
        result.calDataOrig = CalDataOriginHelper.read((InputStream)in);
        result.calSet = CalibrationSetHelper.read((InputStream)in);
        result.calFunction = CalibrationFunctionHelper.read((InputStream)in);
        result.antennaMotionPattern = AntennaMotionPatternHelper.read((InputStream)in);
        result.onlineCalibration = in.read_boolean();
        return result;
    }

    public static void write(OutputStream out, ScanIntentData s) {
        ScanIntentHelper.write((OutputStream)out, (ScanIntent)s.scanIntent);
        CalDataOriginHelper.write((OutputStream)out, (CalDataOrigin)s.calDataOrig);
        CalibrationSetHelper.write((OutputStream)out, (CalibrationSet)s.calSet);
        CalibrationFunctionHelper.write((OutputStream)out, (CalibrationFunction)s.calFunction);
        AntennaMotionPatternHelper.write((OutputStream)out, (AntennaMotionPattern)s.antennaMotionPattern);
        out.write_boolean(s.onlineCalibration);
    }
}

