/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;

public class SquareRootSolver
extends AbstractSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;

    public SquareRootSolver(Matrix a) {
        super(a);
    }

    @Override
    public Vector solve(Vector b) {
        int i;
        this.ensureRHSIsCorrect(b);
        Matrix s = this.a.blank();
        Matrix d = this.a.blank();
        Vector x = b.blankOfLength(this.unknowns());
        Vector y = b.blankOfLength(this.unknowns());
        Vector z = b.blankOfLength(this.unknowns());
        for (i = 0; i < this.a.rows(); ++i) {
            double dd = 0.0;
            for (int l = 0; l < i; ++l) {
                double sli = s.get(l, i);
                dd += sli * sli * d.get(l, l);
            }
            d.set(i, i, Math.signum(this.a.get(i, i) - dd));
            s.set(i, i, Math.sqrt(Math.abs(this.a.get(i, i) - dd)));
            if (s.get(i, i) == 0.0) {
                this.fail("This matrix is singular. We can't solve it.");
            }
            for (int j = i + 1; j < this.a.columns(); ++j) {
                double acc = 0.0;
                for (int l = 0; l < i; ++l) {
                    double sli = s.get(l, i);
                    double slj = s.get(l, j);
                    acc += sli * slj * d.get(l, l);
                }
                s.set(i, j, (this.a.get(i, j) - acc) / (s.get(i, i) * d.get(i, i)));
            }
            double zz = 0.0;
            for (int l = 0; l < i; ++l) {
                zz += z.get(l) * s.get(l, i);
            }
            z.set(i, (b.get(i) - zz) / s.get(i, i));
            y.set(i, z.get(i) / d.get(i, i));
        }
        for (i = this.a.rows() - 1; i >= 0; --i) {
            double acc = 0.0;
            for (int l = i + 1; l < this.a.columns(); ++l) {
                acc += x.get(l) * s.get(i, l);
            }
            x.set(i, (y.get(i) - acc) / s.get(i, i));
        }
        return x;
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.is(Matrices.SYMMETRIC_MATRIX);
    }
}

