/*
 * Decompiled with CFR 0.152.
 */
package org.la4j;

import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.decomposition.CholeskyDecompositor;
import org.la4j.decomposition.EigenDecompositor;
import org.la4j.decomposition.LUDecompositor;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.decomposition.QRDecompositor;
import org.la4j.decomposition.RawLUDecompositor;
import org.la4j.decomposition.RawQRDecompositor;
import org.la4j.decomposition.SingularValueDecompositor;
import org.la4j.inversion.GaussJordanInverter;
import org.la4j.inversion.MatrixInverter;
import org.la4j.inversion.NoPivotGaussInverter;
import org.la4j.linear.ForwardBackSubstitutionSolver;
import org.la4j.linear.GaussianSolver;
import org.la4j.linear.JacobiSolver;
import org.la4j.linear.LeastSquaresSolver;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.linear.SeidelSolver;
import org.la4j.linear.SquareRootSolver;
import org.la4j.linear.SweepSolver;
import org.la4j.operation.MatrixMatrixOperation;
import org.la4j.operation.MatrixOperation;
import org.la4j.operation.MatrixVectorOperation;
import org.la4j.operation.VectorMatrixOperation;
import org.la4j.operation.VectorVectorOperation;
import org.la4j.operation.inplace.InPlaceCopyMatrixToMatrix;
import org.la4j.operation.ooplace.OoPlaceInnerProduct;
import org.la4j.operation.ooplace.OoPlaceKroneckerProduct;
import org.la4j.operation.ooplace.OoPlaceMatricesAddition;
import org.la4j.operation.ooplace.OoPlaceMatricesMultiplication;
import org.la4j.operation.ooplace.OoPlaceMatricesSubtraction;
import org.la4j.operation.ooplace.OoPlaceMatrixByItsTransposeMultiplication;
import org.la4j.operation.ooplace.OoPlaceMatrixByVectorMultiplication;
import org.la4j.operation.ooplace.OoPlaceMatrixHadamardProduct;
import org.la4j.operation.ooplace.OoPlaceOuterProduct;
import org.la4j.operation.ooplace.OoPlaceVectorByMatrixMultiplication;
import org.la4j.operation.ooplace.OoPlaceVectorHadamardProduct;
import org.la4j.operation.ooplace.OoPlaceVectorsAddition;
import org.la4j.operation.ooplace.OoPlaceVectorsSubtraction;

public final class LinearAlgebra {
    public static final String VERSION = "0.5.5";
    public static final String NAME = "la4j";
    public static final String DATE = "March 2015";
    public static final String FULL_NAME = "la4j-0.5.5 (March 2015)";
    public static final double EPS;
    public static final int ROUND_FACTOR;
    public static final SolverFactory GAUSSIAN;
    public static final SolverFactory JACOBI;
    public static final SolverFactory SEIDEL;
    public static final SolverFactory LEAST_SQUARES;
    public static final SolverFactory FORWARD_BACK_SUBSTITUTION;
    public static final SolverFactory SQUARE_ROOT;
    public static final SolverFactory SOLVER;
    public static final SolverFactory SWEEP;
    public static final InverterFactory GAUSS_JORDAN;
    public static final InverterFactory NO_PIVOT_GAUSS;
    public static final InverterFactory INVERTER;
    public static final DecompositorFactory CHOLESKY;
    public static final DecompositorFactory EIGEN;
    public static final DecompositorFactory RAW_LU;
    public static final DecompositorFactory LU;
    public static final DecompositorFactory RAW_QR;
    public static final DecompositorFactory QR;
    public static final DecompositorFactory SVD;
    public static final VectorVectorOperation<Double> OO_PLACE_INNER_PRODUCT;
    public static final VectorVectorOperation<Vector> OO_PLACE_VECTORS_ADDITION;
    public static final VectorVectorOperation<Vector> OO_PLACE_VECTOR_HADAMARD_PRODUCT;
    public static final VectorVectorOperation<Vector> OO_PLACE_VECTORS_SUBTRACTION;
    public static final VectorMatrixOperation<Vector> OO_PLACE_VECTOR_BY_MATRIX_MULTIPLICATION;
    public static final VectorVectorOperation<Matrix> OO_PLACE_OUTER_PRODUCT;
    public static final MatrixMatrixOperation<Matrix> IN_PLACE_COPY_MATRIX_TO_MATRIX;
    public static final MatrixMatrixOperation<Matrix> OO_PLACE_MATRIX_ADDITION;
    public static final MatrixVectorOperation<Vector> OO_PLACE_MATRIX_BY_VECTOR_MULTIPLICATION;
    public static final MatrixMatrixOperation<Matrix> OO_PLACE_MATRICES_SUBTRACTION;
    public static final MatrixMatrixOperation<Matrix> OO_PLACE_MATRIX_HADAMARD_PRODUCT;
    public static final MatrixOperation<Matrix> OO_PLACE_MATRIX_BY_ITS_TRANSPOSE_MULTIPLICATION;
    public static final MatrixMatrixOperation<Matrix> OO_PLACE_KRONECKER_PRODUCT;
    public static final MatrixMatrixOperation<Matrix> OO_PLACE_MATRICES_MULTIPLICATION;

    static {
        int roundFactor = 0;
        double eps = 1.0;
        while (1.0 + eps > 1.0) {
            eps /= 2.0;
            ++roundFactor;
        }
        EPS = eps * 100.0;
        ROUND_FACTOR = roundFactor - 1;
        GAUSSIAN = SolverFactory.GAUSSIAN;
        JACOBI = SolverFactory.JACOBI;
        SEIDEL = SolverFactory.SEIDEL;
        LEAST_SQUARES = SolverFactory.LEAST_SQUARES;
        FORWARD_BACK_SUBSTITUTION = SolverFactory.FORWARD_BACK_SUBSTITUTION;
        SQUARE_ROOT = SolverFactory.SQUARE_ROOT;
        SOLVER = SolverFactory.SMART;
        SWEEP = SolverFactory.SWEEP;
        GAUSS_JORDAN = InverterFactory.GAUSS_JORDAN;
        NO_PIVOT_GAUSS = InverterFactory.NO_PIVOT_GAUSS;
        INVERTER = InverterFactory.SMART;
        CHOLESKY = DecompositorFactory.CHOLESKY;
        EIGEN = DecompositorFactory.EIGEN;
        RAW_LU = DecompositorFactory.RAW_LU;
        LU = DecompositorFactory.LU;
        RAW_QR = DecompositorFactory.RAW_QR;
        QR = DecompositorFactory.QR;
        SVD = DecompositorFactory.SVD;
        OO_PLACE_INNER_PRODUCT = new OoPlaceInnerProduct();
        OO_PLACE_VECTORS_ADDITION = new OoPlaceVectorsAddition();
        OO_PLACE_VECTOR_HADAMARD_PRODUCT = new OoPlaceVectorHadamardProduct();
        OO_PLACE_VECTORS_SUBTRACTION = new OoPlaceVectorsSubtraction();
        OO_PLACE_VECTOR_BY_MATRIX_MULTIPLICATION = new OoPlaceVectorByMatrixMultiplication();
        OO_PLACE_OUTER_PRODUCT = new OoPlaceOuterProduct();
        IN_PLACE_COPY_MATRIX_TO_MATRIX = new InPlaceCopyMatrixToMatrix();
        OO_PLACE_MATRIX_ADDITION = new OoPlaceMatricesAddition();
        OO_PLACE_MATRIX_BY_VECTOR_MULTIPLICATION = new OoPlaceMatrixByVectorMultiplication();
        OO_PLACE_MATRICES_SUBTRACTION = new OoPlaceMatricesSubtraction();
        OO_PLACE_MATRIX_HADAMARD_PRODUCT = new OoPlaceMatrixHadamardProduct();
        OO_PLACE_MATRIX_BY_ITS_TRANSPOSE_MULTIPLICATION = new OoPlaceMatrixByItsTransposeMultiplication();
        OO_PLACE_KRONECKER_PRODUCT = new OoPlaceKroneckerProduct();
        OO_PLACE_MATRICES_MULTIPLICATION = new OoPlaceMatricesMultiplication();
    }

    public static enum DecompositorFactory {
        CHOLESKY{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new CholeskyDecompositor(matrix);
            }
        }
        ,
        EIGEN{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new EigenDecompositor(matrix);
            }
        }
        ,
        RAW_LU{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new RawLUDecompositor(matrix);
            }
        }
        ,
        LU{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new LUDecompositor(matrix);
            }
        }
        ,
        RAW_QR{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new RawQRDecompositor(matrix);
            }
        }
        ,
        QR{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new QRDecompositor(matrix);
            }
        }
        ,
        SVD{

            @Override
            public MatrixDecompositor create(Matrix matrix) {
                return new SingularValueDecompositor(matrix);
            }
        };


        public abstract MatrixDecompositor create(Matrix var1);
    }

    public static enum InverterFactory {
        GAUSS_JORDAN{

            @Override
            public MatrixInverter create(Matrix matrix) {
                return new GaussJordanInverter(matrix);
            }
        }
        ,
        NO_PIVOT_GAUSS{

            @Override
            public MatrixInverter create(Matrix matrix) {
                return new NoPivotGaussInverter(matrix);
            }
        }
        ,
        SMART{

            @Override
            public MatrixInverter create(Matrix matrix) {
                return new GaussJordanInverter(matrix);
            }
        };


        public abstract MatrixInverter create(Matrix var1);
    }

    public static enum SolverFactory {
        GAUSSIAN{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new GaussianSolver(matrix);
            }
        }
        ,
        JACOBI{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new JacobiSolver(matrix);
            }
        }
        ,
        SEIDEL{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new SeidelSolver(matrix);
            }
        }
        ,
        FORWARD_BACK_SUBSTITUTION{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new ForwardBackSubstitutionSolver(matrix);
            }
        }
        ,
        LEAST_SQUARES{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new LeastSquaresSolver(matrix);
            }
        }
        ,
        SQUARE_ROOT{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new SquareRootSolver(matrix);
            }
        }
        ,
        SWEEP{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                return new SweepSolver(matrix);
            }
        }
        ,
        SMART{

            @Override
            public LinearSystemSolver create(Matrix matrix) {
                if (matrix.rows() == matrix.columns()) {
                    return new ForwardBackSubstitutionSolver(matrix);
                }
                if (matrix.rows() > matrix.columns()) {
                    return new LeastSquaresSolver(matrix);
                }
                throw new IllegalArgumentException("Underdetermined system of linear equations can not be solved.");
            }
        };


        public abstract LinearSystemSolver create(Matrix var1);
    }
}

