/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.util.Convert;
import jsky.util.gui.BasicWindowMonitor;

public class VRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final String DEFAULT_NAME = "value";
    private static final int SLIDER_PREF_HEIGHT = 42;
    private static final int SLIDER_PREF_WIDTH = 300;
    private static final int GRIP_WIDTH = 9;
    private static final int GRIP_HEIGHT = 17;
    private static final int GRIP_TOP_Y = 4;
    private static final int GRIP_BOTTOM_Y = 21;
    private static final int GRIP_MIDDLE_Y = 12;
    private static final int SLIDER_LINE_HEIGHT = 19;
    private static final int SLIDER_LINE_WIDTH = 2;
    private static final int FONT_HEIGHT = 15;
    private static final int FONT_TOP_Y = 27;
    private static final int FONT_BOTTOM_Y = 40;
    private int minGrip = 9;
    private int maxGrip = 291;
    protected double minValue = 0.0;
    protected double maxValue = 100.0;
    protected double minLimit = 0.0;
    protected double maxLimit = 1.0;
    private boolean minSlide = false;
    private boolean maxSlide = false;
    private boolean lSlideMoved = false;
    private boolean rSlideMoved = false;
    private boolean textChanged = false;
    private String name;
    private double lastMinLimit = 0.0;
    private double lastMaxLimit = 0.0;
    private String lastCurStr = "";
    protected Dimension minSize = null;
    protected Dimension prefSize = null;
    protected Dimension maxSize = null;
    private BasicStroke shadowStroke = new BasicStroke(1.0f);
    private BasicStroke defaultStroke = new BasicStroke();
    private Color arrowColor = Color.yellow;
    protected EventListenerList listenerList = new EventListenerList();
    private int oldX;

    public VRangeSlider(String label, double min, double max) {
        this.name = label;
        this.resetValues(min, max);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double[] getMinMaxValues() {
        return new double[]{this.minValue, this.maxValue};
    }

    protected void resetValues(double min, double max) {
        this.minLimit = min;
        this.maxLimit = max;
        this.minGrip = 9;
        this.maxGrip = this.getSize().width - 9;
        this.minSlide = false;
        this.maxSlide = false;
        this.lSlideMoved = true;
        this.rSlideMoved = true;
        this.textChanged = true;
        int w = this.getSize().width;
        this.minValue = this.gripToValue(this.minGrip, w);
        this.maxValue = this.gripToValue(this.maxGrip, w);
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.textChanged = true;
        this.repaint();
    }

    public void setBounds(double min, double max) {
        this.resetValues(min, max);
        this.valuesUpdated();
        this.repaint();
    }

    public void setValues(double lo, double hi) {
        int w = this.getSize().width;
        this.minValue = lo;
        int g = this.minGrip;
        this.minGrip = this.valueToGrip(this.minValue, w);
        if (g != this.minGrip) {
            this.lSlideMoved = true;
        }
        this.maxValue = hi;
        g = this.maxGrip;
        this.maxGrip = this.valueToGrip(this.maxValue, w);
        if (g != this.maxGrip) {
            this.rSlideMoved = true;
        }
        this.textChanged = true;
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        int lastW = this.getSize().width;
        super.setBounds(x, y, w, h);
        if (lastW != w) {
            this.minGrip = this.valueToGrip(this.minValue, w);
            this.maxGrip = this.valueToGrip(this.maxValue, w);
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            this.drawLabels(g2, lastW);
            if (g2 != null) {
                g2.dispose();
            }
        }
    }

    private static boolean containedIn(int px, int py, int x, int y, int w, int h) {
        return new Rectangle(x, y, w, h).contains(px, py);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int w = this.getSize().width;
        int x = e.getX();
        int y = e.getY();
        this.oldX = x;
        if (VRangeSlider.containedIn(x, y, this.minGrip - 8, 4, 9, 17)) {
            this.minSlide = true;
        } else if (VRangeSlider.containedIn(x, y, this.maxGrip, 4, 9, 17)) {
            this.maxSlide = true;
        } else if (VRangeSlider.containedIn(x, y, this.minGrip, 1, this.maxGrip - this.minGrip, 22)) {
            this.minSlide = true;
            this.maxSlide = true;
        } else if (VRangeSlider.containedIn(x, y, 0, 1, this.minGrip - 9, 22)) {
            this.minGrip = x < 9 ? 9 : x;
            this.minValue = this.gripToValue(this.minGrip, w);
            this.minSlide = true;
            this.lSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        } else if (VRangeSlider.containedIn(x, y, this.maxGrip + 1 - 9, 1, w - this.maxGrip + 9, 22)) {
            this.maxGrip = x > w - 9 ? w - 9 : x;
            this.maxValue = this.gripToValue(this.maxGrip, w);
            this.maxSlide = true;
            this.rSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.minSlide = false;
        this.maxSlide = false;
        this.textChanged = true;
        this.repaint();
        this.fireChange();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int w = this.getSize().width;
        int x = e.getX();
        int y = e.getY();
        if (this.minSlide && this.maxSlide) {
            int change = x - this.oldX;
            if (this.minGrip + change < 9) {
                change = 9 - this.minGrip;
            } else if (this.maxGrip + change > w - 9) {
                change = w - 9 - this.maxGrip;
            }
            if (change != 0) {
                this.minGrip += change;
                this.minValue = this.gripToValue(this.minGrip, w);
                this.maxGrip += change;
                this.maxValue = this.gripToValue(this.maxGrip, w);
                this.lSlideMoved = true;
                this.rSlideMoved = true;
                this.valuesUpdated();
                this.repaint();
            }
        } else if (this.minSlide) {
            this.minGrip = x < 9 ? 9 : (x >= this.maxGrip ? this.maxGrip - 1 : x);
            this.minValue = this.gripToValue(this.minGrip, w);
            this.lSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        } else if (this.maxSlide) {
            this.maxGrip = x > w - 9 ? w - 9 : (x <= this.minGrip ? this.minGrip + 1 : x);
            this.maxValue = this.gripToValue(this.maxGrip, w);
            this.rSlideMoved = true;
            this.valuesUpdated();
            this.repaint();
        }
        this.oldX = x;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(0, 42);
        }
        return this.minSize;
    }

    @Override
    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, 42);
        }
        return this.prefSize;
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 42);
        }
        return this.maxSize;
    }

    @Override
    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    private double gripToValue(int pos, int width) {
        return (this.maxLimit - this.minLimit) * (double)(pos - 9) / (double)(width - 18) + this.minLimit;
    }

    private int valueToGrip(double value, int width) {
        double rdouble = (value - this.minLimit) * (double)(width - 18) / (this.maxLimit - this.minLimit);
        rdouble = rdouble < 0.0 ? (rdouble -= 0.5) : (rdouble += 0.5);
        return (int)rdouble + 9;
    }

    public void valuesUpdated() {
    }

    @Override
    public void paintComponent(Graphics g) {
        int[] ypts;
        int i;
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getSize().width;
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        g2.setColor(bg);
        g2.fillRect(0, 0, w, 42);
        int right = w - 1;
        Line2D.Double[] lines = new Line2D.Double[]{new Line2D.Double(0.0, 12.0, right, 12.0), new Line2D.Double(0.0, 0.0, 0.0, 23.0), new Line2D.Double(0.0, 0.0, 2.0, 0.0), new Line2D.Double(0.0, 23.0, 2.0, 23.0), new Line2D.Double(right, 0.0, right, 23.0), new Line2D.Double(right, 0.0, right - 2, 0.0), new Line2D.Double(right, 23.0, right - 2, 23.0)};
        g2.setColor(fg);
        for (i = 0; i < lines.length; ++i) {
            g2.draw(lines[i]);
        }
        g2.setStroke(this.shadowStroke);
        g2.setColor(Color.white);
        for (i = 0; i < lines.length; ++i) {
            lines[i].y1 += 1.0;
            lines[i].y2 += 1.0;
            g2.draw(lines[i]);
        }
        this.lSlideMoved = true;
        this.rSlideMoved = true;
        this.textChanged = true;
        if (this.lSlideMoved) {
            g2.setColor(bg);
            g2.fillRect(2, 4, this.maxGrip - 3, 17);
            g2.setColor(fg);
            g2.drawLine(2, 12, this.maxGrip - 3, 12);
            g2.setStroke(this.shadowStroke);
            g2.setColor(Color.white);
            g2.drawLine(2, 13, this.maxGrip - 3, 13);
            g2.setStroke(this.defaultStroke);
            g2.setColor(this.arrowColor);
            int[] xpts = new int[]{this.minGrip - 9, this.minGrip + 1, this.minGrip + 1};
            ypts = new int[]{12, 4, 21};
            g2.fillPolygon(xpts, ypts, 3);
        }
        if (this.rSlideMoved) {
            g2.setColor(bg);
            g2.fillRect(this.minGrip + 1, 4, w - this.minGrip - 3, 17);
            g2.setColor(fg);
            g2.drawLine(this.minGrip + 1, 12, w - 3, 12);
            g2.setStroke(this.shadowStroke);
            g2.setColor(Color.white);
            g2.drawLine(this.minGrip + 1, 13, w - 3, 13);
            g2.setStroke(this.defaultStroke);
            g2.setColor(this.arrowColor);
            int[] xpts = new int[]{this.maxGrip + 9 - 1, this.maxGrip, this.maxGrip};
            ypts = new int[]{12, 4, 21};
            g2.fillPolygon(xpts, ypts, 3);
        }
        if (this.lSlideMoved || this.rSlideMoved) {
            g2.setColor(Color.gray);
            g2.draw3DRect(this.minGrip + 1, 5, this.maxGrip - this.minGrip - 1, 15, true);
            g2.fill3DRect(this.minGrip + 1, 5, this.maxGrip - this.minGrip - 1, 15, true);
        }
        if (this.textChanged) {
            this.drawLabels(g2, w);
        }
        this.lSlideMoved = false;
        this.rSlideMoved = false;
        this.textChanged = false;
    }

    private void drawLabels(Graphics2D g2, int lastW) {
        int sw;
        int w = this.getSize().width;
        FontMetrics fm = g2.getFontMetrics();
        if (this.lastMinLimit != this.minLimit || lastW != w) {
            g2.setColor(this.getBackground());
            sw = fm.stringWidth("" + this.lastMinLimit);
            g2.fillRect(1, 27, sw, 15);
            this.lastMinLimit = this.minLimit;
        }
        if (this.lastMaxLimit != this.maxLimit || lastW != w) {
            g2.setColor(this.getBackground());
            sw = fm.stringWidth("" + this.lastMaxLimit);
            g2.fillRect(lastW - 4 - sw, 27, sw, 15);
            this.lastMaxLimit = this.maxLimit;
        }
        String minS = Convert.shortString((double)this.minValue);
        String maxS = Convert.shortString((double)this.maxValue);
        String curStr = this.name + " = (" + minS + ", " + maxS + ")";
        if (!curStr.equals(this.lastCurStr) || lastW != w) {
            g2.setColor(this.getBackground());
            int sw2 = fm.stringWidth(this.lastCurStr);
            g2.fillRect((lastW - sw2) / 2, 27, sw2, 15);
            this.lastCurStr = curStr;
        }
        g2.setColor(this.getForeground());
        g2.drawString(Convert.shortString((double)this.minLimit), 1, 40);
        String maxStr = Convert.shortString((double)this.maxLimit);
        g2.drawString(maxStr, w - 4 - fm.stringWidth(maxStr), 40);
        g2.drawString(curStr, (w - fm.stringWidth(curStr)) / 2, 40);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Test");
        VRangeSlider rs = new VRangeSlider("", 0.0, 100.0);
        rs.setBounds(-200.0, 4500.0);
        rs.setValues(22.2222, 1000.5432);
        frame.getContentPane().add((Component)rs, "North");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

