/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import jsky.util.gui.DialogUtil;

public class SwingUtil {
    public static void showFrame(JFrame frame) {
        frame.setVisible(true);
        frame.setState(0);
    }

    public static JFrame getFrame(Component window) {
        if (window == null) {
            return DialogUtil.getActiveFrame();
        }
        if (window instanceof JFrame) {
            return (JFrame)window;
        }
        return SwingUtil.getFrame(window.getParent());
    }

    public static void positionAfter(Component first, Window second) {
        GraphicsConfiguration gc = second.getGraphicsConfiguration();
        if (first == null || gc.equals(first.getGraphicsConfiguration())) {
            Point pos = null;
            if (first != null) {
                pos = first.getLocation();
            }
            if (pos == null) {
                pos = new Point(20, 20);
            }
            pos.x += 60;
            pos.y += 60;
            Rectangle newloc = new Rectangle(second.getBounds());
            newloc.setLocation(pos);
            Rectangle screen = gc.getBounds();
            if (screen.x <= newloc.x && screen.y <= newloc.y && screen.x + screen.width >= newloc.x + newloc.width && screen.y + screen.height >= newloc.y + newloc.height) {
                second.setLocation(pos);
            }
        }
    }
}

