/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressPanel;

public class PrintUtil {
    private static final I18N _I18N = I18N.getInstance(PrintUtil.class);
    private Printable _printable;
    private static final String _ATTR_FILE = "jsky.printerAttr";
    private String _title;
    private PrinterJob _printerJob;
    private HashPrintRequestAttributeSet _printerAttr;
    private ProgressPanel _progressPanel;
    private boolean _useBgThread = true;

    public PrintUtil(Printable p) {
        this._printable = p;
    }

    public PrintUtil(Printable p, String title) {
        this._printable = p;
        this._title = title;
    }

    public ProgressPanel getProgressPanel() {
        return this._progressPanel;
    }

    public static void print(Printable p, String title) {
        try {
            new PrintUtil(p, title).print();
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public static void print(Printable p) {
        try {
            new PrintUtil(p).print();
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setAttribute(Attribute attr) {
        this._restorePrinterAttr();
        if (!this._printerAttr.containsKey(attr.getClass())) {
            this._printerAttr.add(attr);
        }
    }

    public void setUseBgThread(boolean b) {
        this._useBgThread = b;
    }

    public void print(String title) throws PrinterException {
        this.setTitle(title);
        this.print();
    }

    public void print() throws PrinterException {
        if (this._printerJob == null) {
            this._printerJob = PrinterJob.getPrinterJob();
        }
        if (this._title != null) {
            this._printerJob.setJobName(this._title);
        }
        this._printerJob.setPrintable(this._printable);
        String prefKey = this.getClass().getName() + ".printer";
        String printer = Preferences.get((String)prefKey);
        if (printer != null) {
            PrintService[] ar = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < ar.length; ++i) {
                if (!printer.equals(ar[i].getName())) continue;
                this._printerJob.setPrintService(ar[i]);
                break;
            }
        }
        try {
            this._restorePrinterAttr();
            if (this._printerJob.printDialog(this._printerAttr)) {
                PrintService ps = this._printerJob.getPrintService();
                if (ps == null) {
                    return;
                }
                Preferences.set((String)prefKey, (String)ps.getName());
                this._savePrinterAttr();
                if (this._useBgThread) {
                    new PrintWorker().start();
                } else {
                    this._printerJob.print(this._printerAttr);
                }
            }
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    private void _savePrinterAttr() {
        if (this._printerAttr != null) {
            try {
                Preferences.getPreferences().serialize(_ATTR_FILE, (Object)this._printerAttr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void _restorePrinterAttr() {
        if (this._printerAttr == null) {
            try {
                this._printerAttr = (HashPrintRequestAttributeSet)Preferences.getPreferences().deserialize(_ATTR_FILE);
            }
            catch (Exception e) {
                this._printerAttr = new HashPrintRequestAttributeSet();
            }
        }
    }

    private class PrintWorker
    extends SwingWorker {
        private Color _bg;

        public PrintWorker() {
            String msg = _I18N.getString("printing");
            if (PrintUtil.this._progressPanel == null) {
                PrintUtil.this._progressPanel = ProgressPanel.makeProgressPanel(msg);
            } else {
                PrintUtil.this._progressPanel.setTitle(msg);
            }
            PrintUtil.this._progressPanel.start();
            if (PrintUtil.this._printable instanceof JComponent) {
                JComponent c = (JComponent)((Object)PrintUtil.this._printable);
                this._bg = c.getBackground();
                if (!this._bg.equals(Color.white)) {
                    c.setBackground(Color.white);
                }
            }
        }

        public Object construct() {
            try {
                PrintUtil.this._progressPanel.setProgress(5);
                PrintUtil.this._printerJob.print(PrintUtil.this._printerAttr);
            }
            catch (Exception ex) {
                return ex;
            }
            return null;
        }

        public void finished() {
            if (PrintUtil.this._printable instanceof JComponent && !this._bg.equals(Color.white)) {
                JComponent c = (JComponent)((Object)PrintUtil.this._printable);
                c.setBackground(this._bg);
            }
            PrintUtil.this._progressPanel.stop();
            Object o = this.getValue();
            if (o instanceof Exception) {
                DialogUtil.error((Exception)o);
            }
        }
    }
}

