/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jsky.util.gui.BasicRangeSliderUI;

public class MetalRangeSliderUI
extends BasicRangeSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent c) {
        return new MetalRangeSliderUI((JSlider)c, true);
    }

    public MetalRangeSliderUI(JSlider b, boolean showe) {
        super(b, showe);
    }

    @Override
    public void installUI(JComponent c) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = (Integer)UIManager.get("Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(c);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        Object sliderFillProp = c.getClientProperty("JSlider.isFilled");
        if (sliderFillProp != null) {
            this.filledSlider = (Boolean)sliderFillProp;
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new MetalPropertyListener();
    }

    @Override
    public void paintThumbLocal(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, g, 0, 0);
        } else {
            vertThumbIcon.paintIcon(this.slider, g, 0, 0);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    @Override
    public void paintTrack(Graphics g) {
        ColorUIResource trackColor = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(trackLeft + 1, trackBottom, trackRight, trackBottom);
            g.drawLine(trackRight, trackTop + 1, trackRight, trackBottom);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1);
            g.drawLine(trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2);
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
        }
        if (this.filledSlider) {
            int middleOfThumb = 0;
            int fillTop = 0;
            int fillLeft = 0;
            int fillBottom = 0;
            int fillRight = 0;
            if (this.slider.getOrientation() == 0) {
                middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
                middleOfThumb -= this.trackRect.x;
                fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                int n = fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
                if (!this.drawInverted()) {
                    fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                    fillRight = middleOfThumb;
                } else {
                    fillLeft = middleOfThumb;
                    fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                }
            } else {
                middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
                middleOfThumb -= this.trackRect.y;
                fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                int n = fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                if (!this.drawInverted()) {
                    fillTop = middleOfThumb;
                    fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
                } else {
                    fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                    fillBottom = middleOfThumb;
                }
            }
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getBackground());
                g.drawLine(fillLeft, fillTop, fillRight, fillTop);
                g.drawLine(fillLeft, fillTop, fillLeft, fillBottom);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(fillLeft + 1, fillTop + 1, fillRight - fillLeft, fillBottom - fillTop);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(fillLeft, fillTop, fillRight - fillLeft, trackBottom - trackTop);
            }
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = 16;
            size.height = 15;
        } else {
            size.width = 15;
            size.height = 16;
        }
        return size;
    }

    @Override
    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? tickLength + 4 + 1 : tickLength + 4 + 3;
    }

    protected int getTrackWidth() {
        double kIdealTrackWidth = 7.0;
        double kIdealThumbHeight = 16.0;
        double kWidthScalar = 0.4375;
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return 5;
    }

    @Override
    protected void scrollDueToClickInTrack(int dir) {
        this.scrollByUnit(dir);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        g.drawLine(x, 4, x, 4 + tickLength / 2);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        g.drawLine(x, 4, x, 4 + (tickLength - 1));
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            g.drawLine(4, y, 4 + tickLength / 2, y);
        } else {
            g.drawLine(0, y, tickLength / 2, y);
        }
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            g.drawLine(4, y, 4 + tickLength, y);
        } else {
            g.drawLine(0, y, tickLength, y);
        }
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
            super(MetalRangeSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String name = e.getPropertyName();
            if (name.equals("JSlider.isFilled")) {
                MetalRangeSliderUI.this.filledSlider = e.getNewValue() != null ? (Boolean)e.getNewValue() : false;
            }
        }
    }
}

