/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class JTextFieldDouble
extends JTextField {
    private static JTextFieldDouble jt = new JTextFieldDouble(15);
    private static final String INVALID_STRING = "Invalid";
    private static final String NAN_STRING = "NaN";
    private static final String NINFINITY_STRING = "-Infinity";
    private static final String PINFINITY_STRING = "+Infinity";
    private static final String MAXVAL_STRING = "MaxVal";
    private static final String MINVAL_STRING = "MinVal";
    private Color fNormalColor = this.getForeground();
    private Color fErrorColor = Color.red;

    public JTextFieldDouble() {
        this(null, null, 0);
    }

    public JTextFieldDouble(String text) {
        this(null, text, 0);
    }

    public JTextFieldDouble(int columns) {
        this(null, null, columns);
    }

    public JTextFieldDouble(String text, int columns) {
        this(null, text, columns);
    }

    public JTextFieldDouble(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setText(this.getText());
    }

    public void setNormalColor(Color c) {
        this.fNormalColor = c;
        this.setText(this.getText());
    }

    @Override
    public void setForeground(Color c) {
        if (this.fNormalColor == null) {
            this.fNormalColor = c;
        }
        super.setForeground(this.fNormalColor);
    }

    public void setErrorColor(Color c) {
        this.fErrorColor = c;
        this.setText(this.getText());
    }

    public void setText(Double dObject) {
        this.setText((double)dObject);
    }

    public void setText(double q) {
        if (Double.isNaN(q)) {
            this.setText(INVALID_STRING);
        } else if (Double.isInfinite(q)) {
            this.setText(q < Double.POSITIVE_INFINITY ? NINFINITY_STRING : PINFINITY_STRING);
        } else if (q == Double.MAX_VALUE) {
            this.setText(MAXVAL_STRING);
        } else if (q == Double.MIN_VALUE) {
            this.setText(MINVAL_STRING);
        } else {
            this.setText(Double.toString(q));
        }
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        String sl = s.toLowerCase();
        if (s == null) {
            this.setForeground(this.fNormalColor);
        } else if (sl.startsWith(NAN_STRING.toLowerCase()) || sl.startsWith(INVALID_STRING.toLowerCase()) || sl.startsWith(PINFINITY_STRING.toLowerCase()) || sl.startsWith(NINFINITY_STRING.toLowerCase()) || sl.startsWith(MAXVAL_STRING.toLowerCase()) || sl.startsWith(MINVAL_STRING.toLowerCase())) {
            this.setForeground(this.fErrorColor);
        } else {
            this.setForeground(this.fNormalColor);
        }
    }

    public static void main(String[] args) {
        JDialog d = new JDialog();
        d.setSize(300, 150);
        d.getContentPane().setLayout(new FlowLayout());
        d.getContentPane().add(jt);
        jt.setText(44.0);
        d.setVisible(true);
        jt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = event.getActionCommand();
                try {
                    double dd = Double.parseDouble(s);
                    jt.setText(dd);
                }
                catch (Exception e) {
                    jt.setText(s);
                }
            }
        });
    }
}

