/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jsky.util.gui.JTextAreaCellRenderer;

public class JTextAreaCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final int ROW_PAD = 3;
    private JTextArea _textArea;
    private JTable _table;
    private int _row;

    public JTextAreaCellEditor(JTable table) {
        this._table = table;
        this._textArea = new JTextArea(new Document());
        this._textArea.setWrapStyleWord(true);
        this._textArea.setLineWrap(true);
        this._textArea.setBorder(JTextAreaCellRenderer.focusBorder);
        this._textArea.setOpaque(true);
    }

    public JTextArea getTextArea() {
        return this._textArea;
    }

    @Override
    public Object getCellEditorValue() {
        return this._textArea.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._textArea.setText(value == null ? "" : value.toString());
        this._updateRowHeight(row, column, table);
        return this._textArea;
    }

    private void _updateRowHeight(int row, int column, JTable table) {
        if (row < 0 || column < 0) {
            return;
        }
        int tableColWidth = table.getColumnModel().getColumn(column).getWidth();
        Dimension d = this._textArea.getPreferredSize();
        if (d.width != tableColWidth) {
            this._textArea.setSize(new Dimension(tableColWidth, d.height));
            d = this._textArea.getPreferredSize();
        }
        int tableRowHeight = table.getRowHeight(row);
        int defaultTableRowHeight = table.getRowHeight();
        if (d.height < defaultTableRowHeight) {
            d.height = defaultTableRowHeight;
        }
        if (d.height + 3 != tableRowHeight) {
            table.setRowHeight(row, d.height + 3);
        }
    }

    public class Document
    extends PlainDocument {
        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (str.equals("\t") || str.equals("\n")) {
                JTextAreaCellEditor.this.stopCellEditing();
                return;
            }
            super.insertString(offs, str, a);
            JTextAreaCellEditor.this._updateRowHeight(JTextAreaCellEditor.this._table.getSelectedRow(), JTextAreaCellEditor.this._table.getSelectedColumn(), JTextAreaCellEditor.this._table);
        }

        public int getRow() {
            return JTextAreaCellEditor.this._row;
        }
    }
}

