/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import javax.swing.JTable;

public class CustomSelectTable
extends JTable {
    @Override
    public void changeSelection(int row, int col, boolean toggle, boolean expand) {
        if (!this.getModel().isCellEditable(row, col)) {
            int curRow = this.getEditingRow();
            int curCol = this.getEditingColumn();
            if (curRow == -1) {
                curRow = this.getSelectedRow();
            }
            if (curCol == -1) {
                curCol = this.getSelectedColumn();
            }
            int nRows = this.getRowCount();
            int nCols = this.getColumnCount();
            int nextRow = row;
            int nextCol = col;
            if (col == curCol) {
                int direction = row - curRow;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                nextRow = this.findNextEditableRow(row, col, direction, nRows, nCols);
            } else if (row == curRow) {
                int direction = col - curCol;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                int[] nextCell = this.findNextEditableCell(row, col, direction, nRows, nCols);
                nextRow = nextCell[0];
                nextCol = nextCell[1];
            } else {
                int direction = row - curRow;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                if (row == 0 && curRow == nRows - 1) {
                    direction = 1;
                }
                int[] nextCell = this.findNextEditableCell(row, col, direction, nRows, nCols);
                nextRow = nextCell[0];
                nextCol = nextCell[1];
            }
            super.changeSelection(nextRow, nextCol, toggle, expand);
        } else {
            super.changeSelection(row, col, toggle, expand);
        }
    }

    int[] findNextEditableCell(int row, int col, int direction, int nRows, int nCols) {
        int origRow = row;
        int origCol = col;
        do {
            if ((col += direction) >= nCols) {
                col = 0;
                row += direction;
            }
            if (col < 0) {
                col = nCols - 1;
                row += direction;
            }
            if (row >= nRows) {
                row = 0;
            }
            if (row < 0) {
                row = nRows - 1;
            }
            if (!this.isCellEditable(row, col)) continue;
            return new int[]{row, col};
        } while (row != origRow || col != origCol);
        return new int[]{origRow, origCol};
    }

    int findNextEditableRow(int row, int col, int direction, int nRows, int nCols) {
        int origRow = row;
        do {
            if ((row += direction) < 0) {
                row = nRows - 1;
            }
            if (row >= nRows) {
                row = 0;
            }
            if (!this.isCellEditable(row, col)) continue;
            return row;
        } while (row != origRow);
        return origRow;
    }
}

