/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.UserAngleT;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.util.UserAngleUnitMap;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Length;
import alma.valuetypes.Speed;
import alma.valuetypes.UserUnitHelper;
import alma.valuetypes.UserUnitValueUnitPair;
import alma.valuetypes.data.UserAngleData;
import java.util.Arrays;

public class UserAngle
extends UserAngleData
implements UserUnitValueUnitPair<Angle> {
    public static String[] units_AngularResolutionAngle = new String[]{USERUNIT_MAS, USERUNIT_ARCSEC};
    public static String[] units_SmallAngle = new String[]{USERUNIT_FRACTION_OF_MAIN_BEAM, USERUNIT_ARCSEC};
    private static String[] sortedModelUnits = new String[]{UNIT_MAS, UNIT_ARCSEC, UNIT_ARCMIN, UNIT_DEG, UNIT_RAD};
    protected static String[] knownUserUnitList = new String[]{USERUNIT_MAS, USERUNIT_ARCSEC, USERUNIT_ARCMIN, USERUNIT_DEG, USERUNIT_H, USERUNIT_RAD};
    private UserUnitHelper uuhelper;
    private Antenna antenna = Antenna.ANTENNA_12M;
    private Frequency observingFrequency;
    private UserAngleUnitMap unitMap;
    private Speed speed;

    public UserAngle(UserAngleT userAngleT) {
        super(userAngleT);
        this.unitMap().acceptNonModelUnits();
        this.uuhelper = new UserUnitHelper(this);
    }

    protected synchronized void initAsNew() {
        super.initAsNew();
        this.setUserUnit(this.defaultUnit());
    }

    public static UserAngle createUserAngle(Angle angle) {
        return UserAngle.createUserAngle(angle.getContentInUnits(Angle.UNIT_ARCSEC), Angle.UNIT_ARCSEC);
    }

    public static UserAngle createUserAngle(double d, String string) {
        return UserAngle.createUserAngle(d, string, null, Antenna.ANTENNA_12M);
    }

    public static UserAngle createUserAngle(double d, String string, Frequency frequency) {
        return UserAngle.createUserAngle(d, string, frequency, Antenna.ANTENNA_12M);
    }

    public static UserAngle createUserAngle(double d, String string, Frequency frequency, Antenna antenna) {
        UserAngle userAngle = UserAngle.createUserAngle();
        userAngle.setObservingFrequency(frequency);
        userAngle.setAntenna(antenna);
        userAngle.setUserUnit(string);
        userAngle.updateContentAndUnit(d, string);
        return userAngle;
    }

    public static UserAngle createUserAngle(ValueUnitPair valueUnitPair) {
        UserAngle userAngle = UserAngle.createUserAngle();
        userAngle.setUserContentAndUserUnit(valueUnitPair);
        return userAngle;
    }

    public static UserAngle arcAngle(Length length, Length length2) {
        Angle angle = Angle.arcAngle(length, length2);
        return UserAngle.createUserAngle(angle);
    }

    public static boolean isModelSupportUnit(String string) {
        for (String string2 : UserAngle.getKnownUnitList()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] getOrderedKnownModelUnits() {
        return sortedModelUnits;
    }

    @Override
    public String[] getKnownModelUnits() {
        return sortedModelUnits;
    }

    @Override
    public String[] getKnownUserUnits() {
        return knownUserUnitList;
    }

    public synchronized Antenna getAntenna() {
        return this.antenna;
    }

    public synchronized void setAntenna(Antenna antenna) {
        this.antenna = antenna;
        this.unitMap().setAntenna(antenna);
    }

    public synchronized Frequency getObservingFrequency() {
        if (this.observingFrequency == null) {
            this.observingFrequency = Frequency.createFrequency();
        }
        return this.observingFrequency;
    }

    public synchronized Frequency gettrueObservingFrequency() {
        return this.observingFrequency;
    }

    public synchronized void setObservingFrequency(Frequency frequency) {
        this.observingFrequency = frequency;
        UserAngleUnitMap userAngleUnitMap = this.unitMap();
        if (userAngleUnitMap.gettrueObservingFrequency() == null) {
            userAngleUnitMap.setObservingFrequency(frequency);
        } else {
            userAngleUnitMap.gettrueObservingFrequency().setContentAndUnit((ValueUnitPair)frequency);
            userAngleUnitMap.updateUnitMap();
        }
    }

    public synchronized UserAngleUnitMap unitMap() {
        if (this.unitMap == null) {
            this.unitMap = new UserAngleUnitMap(this);
        }
        return this.unitMap;
    }

    public String getFriendlyUnit() {
        return this.uuhelper.getFriendlyUnit();
    }

    public synchronized Speed asSpeed() {
        String string = Speed.UNIT_KM_S;
        double d = this.getContentInUnits(string);
        if (this.speed == null) {
            this.speed = Speed.createSpeed();
        }
        this.speed.setContentAndUnit(d, string);
        return this.speed;
    }

    public synchronized UserAngle deepCopy() {
        return super.deepCopy();
    }

    protected synchronized void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
        UserAngle userAngle = (UserAngle)iBusinessObject;
        String[] stringArray = userAngle.gettrueUserUnitList();
        if (stringArray != null) {
            this.setUserUnitList(Arrays.copyOf(stringArray, stringArray.length));
        }
        if (userAngle.observingFrequency != null) {
            this.unitMap().suspendUnitMapUpdater();
            this.setObservingFrequency(userAngle.getObservingFrequency().deepCopy());
            this.unitMap().resumeUnitMapUpdater();
        } else {
            this.setObservingFrequency(null);
        }
    }

    public double getContentInUnits(String string) {
        return this.uuhelper.getContentInUnits(string);
    }

    @Override
    public void setUserContent(double d) {
        this.uuhelper.setUserContent(d);
    }

    @Override
    public void setUserContent(double d, String string) {
        this.uuhelper.setUserContent(d, string);
    }

    protected void updateContentAndUnit(double d, String string) {
        this.uuhelper.updateContentAndUnit(d, string);
    }

    public void setUserContentAndUserUnit(double d, String string) {
        this.uuhelper.setUserContentAndUserUnit(d, string);
    }

    public void setUserContentAndUserUnit(ValueUnitPair valueUnitPair) {
        this.uuhelper.setUserContentAndUserUnit(valueUnitPair);
    }

    @Override
    public double getUserContent() {
        return this.uuhelper.getUserContent();
    }

    @Override
    public String gettrueUserUnit() {
        return this.uuhelper.gettrueUserUnit();
    }

    public String[] gettrueUserUnitList() {
        return this.uuhelper.gettrueUserUnitList();
    }

    @Override
    public String[] getUserUnitList() {
        return this.uuhelper.getUserUnitList();
    }

    @Override
    public void setUserUnitList(String[] stringArray) {
        this.uuhelper.setUserUnitList(stringArray);
    }

    @Override
    public void convertToUserUnit(String string) {
        this.uuhelper.convertToUserUnit(string);
    }

    @Override
    public boolean isModelUnit(String string) {
        return this.uuhelper.isModelUnit(string);
    }

    @Override
    public void dependeeChanged() {
        if (this.uuhelper != null) {
            this.uuhelper.dependeeChanged();
        }
    }

    @Override
    public void unitMapUpdated() {
        this.uuhelper.unitMapUpdated();
    }

    @Override
    public boolean inModelUnit() {
        return this.isModelUnit(this.getUserUnit());
    }

    @Override
    public synchronized void setUserUnit(String string) throws IllegalArgumentException {
        super.setUserUnit(string);
    }

    public Angle getAngle(String string) {
        if (!UserAngle.isModelSupportUnit(string)) {
            throw new IllegalArgumentException(string + " is not a known model unit");
        }
        return Angle.createAngle((double)this.getContentInUnits(string), (String)string);
    }
}

