/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.job;

import alma.obsprep.util.job.ObsprepThreadGroup;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class JobUtility {
    public static Executor inline = new InlineExecution();
    public static Executor swing = new SwingQueue();
    public static Executor otqueue = new OTJobQueue();
    public static Executor oneSecondLater = new OneSecondLater();
    public static Executor fiveSecondsLater = new FiveSecondsLater();

    public static CustomExecutor createCustomExecutor(int n, String string) {
        return new CustomExecutor(n, string);
    }

    public static class CustomExecutor
    extends ScheduledThreadPoolExecutor {
        volatile Thread latestThread;

        public CustomExecutor(int n, final String string) {
            super(n);
            this.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(ObsprepThreadGroup.getInstance(), runnable, string);
                    thread.setDaemon(true);
                    latestThread = thread;
                    return thread;
                }
            });
        }

        @Override
        public void execute(Runnable runnable) {
            super.execute(runnable);
        }
    }

    static class InlineExecution
    implements Executor {
        InlineExecution() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }

    static class SwingQueue
    implements Executor {
        SwingQueue() {
        }

        @Override
        public void execute(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static class OTJobQueue
    extends CustomExecutor {
        public OTJobQueue() {
            super(1, "OT-JobQueue-0");
        }
    }

    static class OneSecondLater
    implements Executor {
        OneSecondLater() {
        }

        @Override
        public void execute(Runnable runnable) {
            ((OTJobQueue)otqueue).schedule(runnable, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    static class FiveSecondsLater
    implements Executor {
        FiveSecondsLater() {
        }

        @Override
        public void execute(Runnable runnable) {
            ((OTJobQueue)otqueue).schedule(runnable, 5000L, TimeUnit.MILLISECONDS);
        }
    }
}

