/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import jsky.catalog.vo.VoTable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class NEDNameResolver
extends Resolver {
    private String nameServer = "ned.ipac.caltech.edu";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(@NonNull String string) throws IOException, MalformedURLException {
        VoTable voTable;
        block9: {
            if (string == null) {
                throw new NullPointerException("objectName is marked non-null but is null");
            }
            Log.logger(this.getClass()).fine("Using NED to resolve " + string);
            this.reset();
            this.setName(string);
            this.results.clear();
            voTable = null;
            try {
                URL uRL = new URL("https://ned.ipac.caltech.edu/cgi-bin/objsearch?objname=" + URLEncoder.encode(StringUtils.trim((String)string), "UTF-8") + "&extend=noout_csys=Equatorial&out_equinox=J2000.0&obj_sort=RA+or+Longitude&of=xml_main&zv_breaker=30000.0&list_limit=10&img_stamp=NO");
                Log.logger(NEDNameResolver.class).info("NED query " + String.valueOf(uRL));
                voTable = VoTable.createVoTable((URL)uRL, (String)string, (String)"sourceDetails");
            }
            catch (IOException iOException) {
                this.failedResolutionHandler("Unable to process VOtable response from NED : " + iOException.getMessage(), string);
            }
            finally {
                if (voTable != null) break block9;
                this.failedResolutionHandler("Unable to resolve source using NED", string);
                return;
            }
        }
        try {
            this.processVOTableResponse(voTable);
            this.setQueryCompleted(true);
        }
        catch (UnableToProcessSourceResolverResponseException unableToProcessSourceResolverResponseException) {
            this.failedResolutionHandler("Unable to process VOTable XML response from NED: " + unableToProcessSourceResolverResponseException.getMessage(), string);
        }
        catch (UnableToResolveObjectException unableToResolveObjectException) {
            this.failedResolutionHandler("NED unable to resolve the object: " + unableToResolveObjectException.getMessage(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVOTableResponse(VoTable voTable) throws UnableToProcessSourceResolverResponseException, UnableToResolveObjectException {
        if (voTable == null) {
            throw new UnableToProcessSourceResolverResponseException("No VOtable query response found");
        }
        this.reset();
        this.ra = this.dec = INVALID;
        NEDNameResolver nEDNameResolver = new NEDNameResolver();
        for (int i = 0; i < voTable.getRowCount(); ++i) {
            for (NEDQueryResponseFields nEDQueryResponseFields : NEDQueryResponseFields.values()) {
                if (!nEDQueryResponseFields.isRequired() || voTable.getValueAt(i, nEDQueryResponseFields.getAttribute()) != null) continue;
                throw new UnableToProcessSourceResolverResponseException("No " + nEDQueryResponseFields.getAttribute() + " found in NED VOtable response");
            }
            nEDNameResolver.setResolverService(Resolver.ResolverService.NED);
            nEDNameResolver.setRa((Double)voTable.getValueAt(i, NEDQueryResponseFields.RA.getAttribute()));
            nEDNameResolver.setDec((Double)voTable.getValueAt(i, NEDQueryResponseFields.DEC.getAttribute()));
            nEDNameResolver.setName((String)voTable.getValueAt(i, NEDQueryResponseFields.PREFNAME.getAttribute()));
            this.results.add(nEDNameResolver);
            try {
                double d = (Double)voTable.getValueAt(i, NEDQueryResponseFields.Z.getAttribute());
                this.sourceVelocity = Velocity.createVelocity();
                this.sourceVelocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_RELATIVISTIC);
                this.sourceVelocity.setReferenceSystem(Velocity.REFERENCESYSTEM_HEL);
                double d2 = this.sourceVelocity.fromRedshift(d).getCenterVelocity().getContentInUnits(Speed.UNIT_KM_S);
                this.sourceVelocity.setCenterVelocity(Speed.createSpeed((double)d2, (String)Speed.UNIT_KM_S));
                nEDNameResolver.setSourceVelocity(this.sourceVelocity);
                continue;
            }
            catch (Exception exception) {
                Log.logger(NEDNameResolver.class).warning("Unable to process NED velocity information: " + exception.getMessage());
                continue;
            }
            finally {
                this.setQuerySuccessful(true);
            }
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        try {
            URL uRL = new URL("https://ned.ipac.caltech.edu/tap/sync?query=SELECT+*+FROM+ned_objdir+WHERE+ned_objdir.prefname='ABELL+0755'&LANG=ADQL&REQUEST=doQuery&FORMAT=votable&MAXREC=2");
            VoTable voTable = VoTable.createVoTable((URL)uRL, (String)"source", (String)"catalog");
            for (Object e : voTable.getColumnIdentifiers()) {
                System.out.println(e);
            }
            System.out.println(voTable.getValueAt(0, "dec"));
            System.out.println(voTable.getValueAt(0, "ra"));
            System.out.println(voTable.getValueAt(0, "prefname"));
            System.out.println(voTable.getValueAt(0, "z"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getNameServer() {
        return this.nameServer;
    }

    @Override
    public void setNameServer(String string) {
        this.nameServer = string;
    }

    public static class UnableToProcessSourceResolverResponseException
    extends Exception {
        public UnableToProcessSourceResolverResponseException(String string) {
        }
    }

    public static class UnableToResolveObjectException
    extends Exception {
    }

    public static enum NEDQueryResponseFields {
        PREFNAME("Object Name", true),
        RA("RA", true),
        DEC("DEC", true),
        Z("Redshift", false);

        private String attribute;
        private boolean isRequired = false;

        private NEDQueryResponseFields(String string2, boolean bl) {
            this.attribute = string2;
            this.isRequired = bl;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }
}

