/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.astro;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.SkyCoordinates;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import skyview.geometry.Position;
import skyview.geometry.TransformationException;

public class CoordsSystemConversionHelper {
    private static final String GALACTIC = "galactic";
    private static final String J2000 = "J2000";
    private static CacheAccess<Integer, SkyPoint> conversionCache = JCS.getInstance((String)"conversionCache");
    private final SkyCoordinates skyCoordinates;
    private static Map<String, String> supportedSystem = new HashMap<String, String>();
    private static Map<String, String> supportedTransform = new HashMap<String, String>();
    private static Map<String, String> nullTransform = new HashMap<String, String>();

    public CoordsSystemConversionHelper(@NonNull SkyCoordinates skyCoordinates) {
        if (skyCoordinates == null) {
            throw new NullPointerException("skyCoordinates is marked non-null but is null");
        }
        this.skyCoordinates = skyCoordinates;
    }

    public SkyPoint getAbsoluteSkyPointInDegInSystem(String string) {
        String string2 = this.skyCoordinates.getSystem();
        String string3 = string;
        SkyPoint skyPoint = new SkyPoint();
        if (!this.isValidSystem(string2) || !this.isValidSystem(string3)) {
            String string4 = "System is not allowed to be null nor empty  (from, to) = (" + string2 + "," + string + ").";
            Log.logger((Object)this).warning(string4);
            return skyPoint;
        }
        if (this.skyCoordinates.isAbsoluteCoordinates()) {
            double d = this.skyCoordinates.getLongitude().getDegs();
            double d2 = this.skyCoordinates.getLatitude().getDegs();
            if (string.equals(string2) || CoordsSystemConversionHelper.isNullTransform(string2, string3)) {
                skyPoint.setLocation(d, d2);
                return skyPoint;
            }
            if (!CoordsSystemConversionHelper.isSupportedTransform(string2, string3)) {
                String string5 = "System conversion from " + string2 + " to " + string + " is not supported yet.";
                Log.logger((Object)this).warning(string5);
                skyPoint.setLocation(0.0, 0.0);
                return skyPoint;
            }
            if (CoordsSystemConversionHelper.isSupportedSystem(string2) && CoordsSystemConversionHelper.isSupportedSystem(string3)) {
                double[] dArray;
                int n = Objects.hashCode((Object[])new Object[]{d, d2, string2});
                SkyPoint skyPoint2 = (SkyPoint)conversionCache.get((Object)n);
                if (skyPoint2 != null) {
                    skyPoint.setLocation(skyPoint2.getX(), skyPoint2.getY());
                    return skyPoint;
                }
                try {
                    dArray = new Position(d, d2, supportedSystem.get(string2)).getCoordinates(supportedSystem.get(string3));
                }
                catch (TransformationException transformationException) {
                    Log.logger((Object)this).warning(transformationException.getMessage());
                    return skyPoint;
                }
                skyPoint.setLocation(dArray[0], dArray[1]);
                conversionCache.put((Object)n, (Object)skyPoint);
                return skyPoint;
            }
        }
        Log.logger((Object)this).warning("Can not get absolute coordinates from an instance of RELATIVE type SkyCoordinates.");
        return skyPoint;
    }

    public boolean isValidSystem(String string) {
        return string != null && string.length() != 0;
    }

    public static boolean isSupportedSystem(String string) {
        return supportedSystem.keySet().contains(string);
    }

    public static boolean isSupportedTransform(String string, String string2) {
        return supportedTransform.keySet().contains(string + string2);
    }

    public static boolean isNullTransform(String string, String string2) {
        return nullTransform.keySet().contains(string + string2);
    }

    static {
        supportedSystem.put(SkyCoordinates.SYSTEM_J2000, J2000);
        supportedSystem.put(SkyCoordinates.SYSTEM_GALACTIC, "Galactic");
        supportedSystem.put(SkyCoordinates.SYSTEM_ICRS, "ICRS");
        supportedTransform.put("J2000galactic", "J2000 to Galactic");
        supportedTransform.put("galacticJ2000", "Galactic to J2000");
        supportedTransform.put("ICRSgalactic", "ICRS to Galactic");
        supportedTransform.put("galacticICRS", "Galactic to ICRS");
        nullTransform.put("J2000ICRS", "J2000 to ICRS");
        nullTransform.put("ICRSJ2000", "ICRS to J2000");
        nullTransform.put("ICRSICRS", "ICRS to ICRS");
        nullTransform.put("J2000J2000", "J2000 to J20000");
    }
}

