/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class WidgetDetective {
    private JFrame frame;
    private Component glassPane;
    private Container contentPane;
    private MouseListener mouseLi;
    private Color savedbackground;
    private boolean savedOpacity;
    private Component currentComp;

    public WidgetDetective(JFrame jFrame) {
        this.frame = jFrame;
    }

    public boolean isOn() {
        return this.mouseLi != null;
    }

    public void on() {
        this.glassPane = this.frame.getGlassPane();
        this.contentPane = this.frame.getContentPane();
        this.mouseLi = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    WidgetDetective.this.off();
                } else {
                    Point point = mouseEvent.getPoint();
                    Point point2 = SwingUtilities.convertPoint(WidgetDetective.this.glassPane, point, WidgetDetective.this.contentPane);
                    StringBuilder stringBuilder = new StringBuilder("Widget Detective:");
                    StringBuilder stringBuilder2 = new StringBuilder("\n");
                    for (Component component = WidgetDetective.this.currentComp = SwingUtilities.getDeepestComponentAt(WidgetDetective.this.contentPane, point2.x, point2.y); component != null; component = component.getParent()) {
                        stringBuilder.append((CharSequence)stringBuilder2);
                        stringBuilder.append(component.getClass().getSimpleName());
                        stringBuilder.append("@" + component.hashCode());
                        stringBuilder.append(",name='" + component.getName() + "'");
                        stringBuilder.append(",enabled=" + component.isEnabled());
                        stringBuilder.append(" || More details: " + String.valueOf(component));
                        stringBuilder2.append(" ");
                    }
                    System.out.println(stringBuilder.toString());
                    WidgetDetective.this.savedOpacity = WidgetDetective.this.currentComp.isOpaque();
                    if (WidgetDetective.this.currentComp instanceof JComponent) {
                        ((JComponent)WidgetDetective.this.currentComp).setOpaque(true);
                    }
                    WidgetDetective.this.savedbackground = WidgetDetective.this.currentComp.getBackground();
                    WidgetDetective.this.currentComp.setBackground(Color.red);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (WidgetDetective.this.currentComp instanceof JComponent) {
                    ((JComponent)WidgetDetective.this.currentComp).setOpaque(WidgetDetective.this.savedOpacity);
                }
                WidgetDetective.this.currentComp.setBackground(WidgetDetective.this.savedbackground);
            }
        };
        this.glassPane.addMouseListener(this.mouseLi);
        this.say("Widget Detective activated. Turn off with right-click.");
        this.glassPane.setVisible(true);
    }

    public void off() {
        this.glassPane.removeMouseListener(this.mouseLi);
        this.glassPane.setVisible(false);
        this.mouseLi = null;
        this.say("Widget Detective deactivated");
    }

    private void say(String string) {
        System.out.println(string);
        JOptionPane.showMessageDialog(this.frame, string);
    }
}

