/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.WeakHashMap;

public class VerticalFlowLayout
implements LayoutManager {
    public static final String STRETCH_WIDTH = "Stretch Width";
    protected int vgap;
    private WeakHashMap<Component, Object> stretch = new WeakHashMap();
    protected Size minimumSize = new Size(this){

        @Override
        Dimension read(Component component) {
            return component.getMinimumSize();
        }
    };
    protected Size preferredSize = new Size(this){

        @Override
        Dimension read(Component component) {
            return component.getPreferredSize();
        }
    };

    public VerticalFlowLayout() {
        this(5);
    }

    public VerticalFlowLayout(int n) {
        this.vgap = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (STRETCH_WIDTH.equalsIgnoreCase(string)) {
            this.stretch.put(component, null);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.stretch.remove(component);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - insets.left - insets.right;
        int n2 = container.getSize().height - insets.top - insets.bottom;
        int n3 = container.getComponentCount();
        if (n3 == 0) {
            return;
        }
        int n4 = insets.top;
        int n5 = insets.left;
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            int n6 = this.stretch.containsKey(component) ? n : dimension.width;
            component.setBounds(n5, n4, n6, dimension.height);
            n4 += dimension.height + this.vgap;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container, this.minimumSize);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container, this.preferredSize);
    }

    protected Dimension layoutSize(Container container, Size size) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = size.read(component);
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom + this.vgap * n3);
        return dimension;
    }

    protected abstract class Size {
        protected Size(VerticalFlowLayout verticalFlowLayout) {
        }

        abstract Dimension read(Component var1);
    }
}

