/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.obsprep.util.OTProgressPanelDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jsky.util.Resources;
import jsky.util.StatusLogger;
import jsky.util.gui.BusyWin;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.StatusPanel;
import jsky.util.gui.SwingUtil;
import lombok.NonNull;

public class OTProgressPanel
extends JPanel
implements ActionListener,
StatusLogger {
    protected final JDialog parent;
    protected String title;
    protected JLabel titleLabel;
    protected JButton cancelButton;
    protected StatusPanel statusPanel;
    protected ProgressBarFilterInputStream loggedInputStream;
    protected boolean isInterrupted;
    protected static OTProgressPanel newPanel;
    private static OTProgressPanelDialog progressPanelDialog;

    public OTProgressPanel(@NonNull JDialog jDialog, @NonNull String string) {
        if (jDialog == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.parent = jDialog;
        this.title = string;
        this.init();
    }

    protected void init() {
        if (!SwingUtilities.isEventDispatchThread()) {
            OTProgressPanel.invokeAndWait(() -> this.init());
            return;
        }
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(this.title, 0);
        this.titleLabel.setForeground(Color.black);
        jPanel.add((Component)this.titleLabel, "West");
        JLabel jLabel = new JLabel(Resources.getIcon((String)"TaskStatusOn.gif"));
        jPanel.add((Component)jLabel, "East");
        JPanel jPanel2 = new JPanel();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "South");
        this.statusPanel = new StatusPanel();
        this.statusPanel.getTextField().setColumns(25);
        this.statusPanel.getProgressBar().setToolTipText("");
        this.add((Component)jPanel, "North");
        this.add((Component)this.statusPanel, "South");
    }

    protected static void invokeAndWait(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTitle(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.setTitle(string));
            return;
        }
        this.title = string;
        this.titleLabel.setText(string);
    }

    public void logMessage(String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.statusPanel.setText(string));
            return;
        }
        this.statusPanel.setText(string);
    }

    public void setText(String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.statusPanel.setText(string));
            return;
        }
        this.statusPanel.setText(string);
    }

    public void addActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.cancelButton.removeActionListener(actionListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.isInterrupted = true;
        this.stop();
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        this.start();
        URLConnection uRLConnection = this.statusPanel.openConnection(uRL);
        if (this.isInterrupted) {
            throw new ProgressException("Interrupted");
        }
        return uRLConnection;
    }

    public void start() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.start());
            return;
        }
        this.isInterrupted = false;
        this.parent.setVisible(true);
        this.statusPanel.getProgressBar().startAnimation();
        BusyWin.setBusy((boolean)true, (Component)this.parent);
    }

    public void startAnimation() {
        this.statusPanel.getProgressBar().startAnimation();
    }

    public void stop() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.stop());
            return;
        }
        BusyWin.setBusy((boolean)false, (Component)this.parent);
        if (this.loggedInputStream != null) {
            this.loggedInputStream.interrupt();
            this.loggedInputStream = null;
        }
        this.parent.setVisible(false);
        this.statusPanel.interrupt();
        this.statusPanel.getProgressBar().stopAnimation();
        this.statusPanel.setText("");
        this.statusPanel.getProgressBar().setStringPainted(false);
        this.statusPanel.getProgressBar().setValue(0);
        this.parent.dispose();
    }

    public static OTProgressPanel makeProgressPanel(String string, Component component) {
        if (!SwingUtilities.isEventDispatchThread()) {
            OTProgressPanel.invokeAndWait(() -> {
                newPanel = OTProgressPanel.makeProgressPanel(string, component);
            });
            return newPanel;
        }
        JFrame jFrame = SwingUtil.getFrame((Component)component);
        progressPanelDialog = new OTProgressPanelDialog(string, jFrame);
        progressPanelDialog.setVisible(true);
        return progressPanelDialog.getProgressPanel();
    }

    public static OTProgressPanel makeProgressPanel(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        return OTProgressPanel.makeProgressPanel(string, DialogUtil.getActiveFrame());
    }

    public void setProgress(int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> {
                this.statusPanel.getProgressBar().stopAnimation();
                this.statusPanel.setProgress(n);
            });
            return;
        }
        this.statusPanel.getProgressBar().stopAnimation();
        this.statusPanel.setProgress(n);
    }

    public ProgressBarFilterInputStream getLoggedInputStream(InputStream inputStream, int n) throws IOException {
        if (this.isInterrupted) {
            throw new ProgressException("Interrupted");
        }
        this.loggedInputStream = this.statusPanel.getLoggedInputStream(inputStream, n);
        return this.loggedInputStream;
    }

    public ProgressBarFilterInputStream getLoggedInputStream(URL uRL) throws IOException {
        if (this.isInterrupted) {
            throw new ProgressException("Interrupted");
        }
        this.loggedInputStream = this.statusPanel.getLoggedInputStream(uRL);
        return this.loggedInputStream;
    }

    public void stopLoggingInputStream(ProgressBarFilterInputStream progressBarFilterInputStream) throws IOException {
        this.loggedInputStream = null;
        this.statusPanel.stopLoggingInputStream(progressBarFilterInputStream);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }
}

