/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.util.Convert;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;

public final class LoggingSetup {
    private static final String PRINT_STACK_TRACE = "alma.obsprep.PrintStackTrace";
    private static final String OT_VERBOSE_CONSOLE = "OT.verboseConsole";
    private static ConsoleOut consoleOut;
    public static final String OT_LOGFILE_NAME = "ot.log";

    public static void configureBasicSetup() {
        try {
            File file = LoggingSetup.prepareLogfile();
            java.util.logging.LogManager logManager = java.util.logging.LogManager.getLogManager();
            logManager.reset();
            Logger logger = logManager.getLogger("");
            FileHandler fileHandler = new FileHandler(file.getPath());
            fileHandler.setFormatter(new LoggingVerboseFormat());
            fileHandler.setLevel(java.util.logging.Level.ALL);
            logger.addHandler(fileHandler);
            consoleOut = new ConsoleOut();
            LoggingSetup.configureConsole();
            logger.addHandler(consoleOut);
            logger.setLevel(java.util.logging.Level.WARNING);
            Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)Level.WARN);
        }
        catch (Exception exception) {
            System.err.println("ObservingTool: Could not configure logging framework (basic setup). Stack trace: ");
            exception.printStackTrace(System.err);
        }
    }

    private static File prepareLogfile() {
        File file2 = new File(System.getProperty("user.home"), ".almaot");
        file2.mkdir();
        File file3 = new File(file2, OT_LOGFILE_NAME);
        File file4 = new File(file2, OT_LOGFILE_NAME);
        if (file4.exists()) {
            long l = file4.lastModified();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd-HH.mm");
            String string2 = simpleDateFormat.format(new Date(l));
            File file5 = new File(file2, "ot." + string2 + ".log");
            file4.renameTo(file5);
        }
        if (file2.isDirectory()) {
            Object[] objectArray = file2.listFiles((file, string) -> string.matches("ot.+log") && !string.equals(OT_LOGFILE_NAME));
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length - 5; ++i) {
                ((File)objectArray[i]).delete();
            }
        }
        if (file2.isDirectory()) {
            File[] fileArray;
            for (File file5 : fileArray = file2.listFiles((file, string) -> string.matches("ot.+lck") && !string.equals("ot.log.lck"))) {
                file5.delete();
            }
        }
        return file3;
    }

    private static void configureConsole() {
        if (Boolean.getBoolean(OT_VERBOSE_CONSOLE)) {
            consoleOut.setFormatter(new LoggingVerboseFormat());
            consoleOut.setLevel(java.util.logging.Level.ALL);
        } else {
            consoleOut.setFormatter(new LoggingTerseFormat());
            consoleOut.setLevel(java.util.logging.Level.INFO);
        }
    }

    public static void consoleOutputForWarningsOnly() {
        consoleOut.setLevel(java.util.logging.Level.WARNING);
    }

    public static void configureLoggers(List<String> list) {
        Log.DEBUG.hashCode();
        try {
            java.util.logging.LogManager logManager = java.util.logging.LogManager.getLogManager();
            for (String string : list) {
                String string2 = System.getProperty(string + ".level");
                Logger logger = logManager.getLogger(string);
                try {
                    java.util.logging.Level level = null;
                    if (string2 != null) {
                        level = java.util.logging.Level.parse(string2);
                    }
                    logger.setLevel(level);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Ignoring illegal log level setting for logger " + string + ": '" + string2 + "'");
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ObservingTool: Could not configure logging framework. Stack trace: ");
            exception.printStackTrace(System.err);
        }
    }

    public static void configureDebugging(List<String> list, String string, boolean bl) {
        Properties properties = System.getProperties();
        properties.remove(PRINT_STACK_TRACE);
        properties.remove(OT_VERBOSE_CONSOLE);
        for (String string2 : list) {
            properties.remove(string2 + ".level");
        }
        properties.put("OT.level", string);
        properties.put("OT.LO.level", "WARNING");
        if (bl) {
            properties.put(PRINT_STACK_TRACE, "true");
            properties.put(OT_VERBOSE_CONSOLE, "true");
        }
        LoggingSetup.configureLoggers(list);
        LoggingSetup.configureConsole();
    }

    private LoggingSetup() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class LoggingVerboseFormat
    extends Formatter {
        LoggingVerboseFormat() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder(Convert.convertToISO(logRecord.getMillis()) + "| " + logRecord.getLevel().getName() + "| " + logRecord.getMessage() + " (" + Thread.currentThread().getName());
            if (logRecord.getSourceClassName() != null && logRecord.getSourceMethodName() != null) {
                stringBuilder.append(", ");
                String string = logRecord.getSourceClassName();
                if (string.endsWith(".java")) {
                    string = string.substring(0, string.length() - 5);
                }
                stringBuilder.append(string.substring(string.lastIndexOf(46) + 1) + "#" + logRecord.getSourceMethodName());
            }
            stringBuilder.append(")" + this.stackTrace(logRecord.getThrown()) + "\n");
            return stringBuilder.toString();
        }

        protected String stackTrace(Throwable throwable) {
            if (throwable == null) {
                return "";
            }
            boolean bl = false;
            bl |= "true".equalsIgnoreCase(java.util.logging.LogManager.getLogManager().getProperty(LoggingSetup.PRINT_STACK_TRACE));
            if (!(bl |= "true".equalsIgnoreCase(System.getProperty(LoggingSetup.PRINT_STACK_TRACE)))) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(5000);
            stringBuilder.append("\n ~ Throwable was: ");
            stringBuilder.append(throwable);
            while (true) {
                StackTraceElement[] stackTraceElementArray;
                for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                    stringBuilder.append("\n ~   ");
                    stringBuilder.append(stackTraceElement.toString());
                }
                if ((throwable = throwable.getCause()) == null) break;
                stringBuilder.append("\n ~ due to: ");
                stringBuilder.append(throwable);
            }
            return stringBuilder.toString();
        }
    }

    static class ConsoleOut
    extends Handler {
        private final Writer stderr;
        private final Writer stdout;
        private final int deviate = java.util.logging.Level.WARNING.intValue();

        ConsoleOut() {
            this.stderr = new OutputStreamWriter(System.err);
            this.stdout = new OutputStreamWriter(System.out);
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (this.isLoggable(logRecord)) {
                Writer writer = logRecord.getLevel().intValue() >= this.deviate ? this.stderr : this.stdout;
                int n = 0;
                try {
                    n = 5;
                    String string = this.getFormatter().format(logRecord);
                    n = 1;
                    writer.write(string);
                    n = 2;
                    writer.flush();
                }
                catch (Exception exception) {
                    this.reportError(null, exception, n);
                }
            }
        }

        @Override
        public void flush() {
            try {
                this.stderr.flush();
                this.stdout.flush();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 2);
            }
        }

        @Override
        public void close() throws SecurityException {
            this.flush();
        }
    }

    public static class LoggingTerseFormat
    extends Formatter {
        @Override
        public String format(LogRecord logRecord) {
            String string = logRecord.getMessage();
            String string2 = Convert.convertToDateTime(new Date(logRecord.getMillis()));
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                return string2 + "  " + string + " (see log file for error details)\n";
            }
            return string2 + "  " + string + "\n";
        }
    }
}

