/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.UnitException;
import alma.obsprep.util.DynamicUnitMap;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserUnitValueUnitPair;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.Set;

public abstract class FrequencyDependentUnitMap
extends DynamicUnitMap {
    protected Frequency observingFrequency;

    public FrequencyDependentUnitMap(UserUnitValueUnitPair userUnitValueUnitPair) {
        super(userUnitValueUnitPair);
    }

    @Override
    protected boolean isDependeeChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        return object == this.observingFrequency && (string.endsWith(".content") || string.endsWith(".unit"));
    }

    public void setObservingFrequency(Frequency frequency) {
        if (this.observingFrequency != null) {
            this.observingFrequency.removePropertyChangeListener(this.unitMapUpdater);
        }
        this.observingFrequency = frequency;
        this.updateUnitMap();
        if (frequency != null) {
            frequency.addPropertyChangeListener(this.unitMapUpdater);
        }
    }

    public Frequency gettrueObservingFrequency() {
        return this.observingFrequency;
    }

    public Frequency getNonZeroObservingFrequency() {
        if (this.observingFrequency == null || this.observingFrequency.isZero()) {
            return Frequency.createFrequencyGHZ(1.0);
        }
        return this.observingFrequency;
    }

    @Override
    public synchronized void updateUnitMap() {
        this.bo.dependeeChanged();
        if (this.observingFrequency == null) {
            this.putAll((Map)this.getStaticNonModelUnitMap());
            return;
        }
        try {
            this.updateNonModelUnitsScale();
        }
        catch (UnitException unitException) {
            throw new RuntimeException(unitException);
        }
        if (this.isUnitMapUpdaterActive) {
            this.bo.unitMapUpdated();
        }
    }

    protected abstract Set<String> getFrequencyDependingUnits();

    public double getConversionFactor(String string, String string2) throws UnitException {
        Set<String> set;
        if (this.observingFrequency == null && ((set = this.getFrequencyDependingUnits()).contains(string) || set.contains(string2))) {
            throw new UnitException("ObservingFrequency is not set.");
        }
        return super.getConversionFactor(string, string2);
    }

    protected abstract void updateNonModelUnitsScale() throws UnitException;
}

