/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.NonNull;

class TextPanelHelper {
    public static final Color titleColor = new Color(0, 128, 0);
    JComponent currentPanel;
    private final DefaultPdfExporter defaultPDFExporter;
    final int pageHeight;
    private final int pageWidth;
    List<JComponent> textPages;

    public TextPanelHelper(DefaultPdfExporter defaultPdfExporter, int n, int n2) {
        this.defaultPDFExporter = defaultPdfExporter;
        this.textPages = new ArrayList<JComponent>();
        this.currentPanel = null;
        this.pageHeight = n;
        this.pageWidth = n2;
    }

    int addComponentToTextPanel(JComponent jComponent) {
        this.currentPanel.add(jComponent);
        this.defaultPDFExporter.doLayout(this.currentPanel);
        return (int)jComponent.getPreferredSize().getHeight();
    }

    JComponent createPage(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("pageLabel is marked non-null but is null");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setPreferredSize(new Dimension(this.pageWidth, 0));
        this.currentPanel = this.defaultPDFExporter.addHeaderLabelToView(jPanel, new JLabel(string));
        this.currentPanel.setVisible(true);
        this.currentPanel.setSize(new Dimension(this.pageWidth, 0));
        this.textPages.add(this.currentPanel);
        this.defaultPDFExporter.doLayout(this.currentPanel);
        return this.currentPanel;
    }
}

