/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.services.summaryfeedback.TuningInfo;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import javax.swing.table.AbstractTableModel;

public class SpectralLineSetupTableModel
extends AbstractTableModel {
    protected TuningInfo tuningInfo;
    private final String[] longValues = new String[]{" 0 ", " 100.123456 ", "xxx-xxx-xxx-xxx-xxx-xxx", " 9999 ", " 1000.0 MHz ", " 11100.00 kHz  ", " 5600 - 6000 km/s ", "2.9-3.2 km/s", "20-21"};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.tuningInfo == null ? 0 : this.tuningInfo.getNumSpectralWindows();
    }

    public TuningInfo getParameters() {
        return this.tuningInfo;
    }

    public void setDocument(TuningInfo tuningInfo) {
        this.tuningInfo = tuningInfo;
    }

    public ScienceGoal getScienceGoal() {
        return this.tuningInfo.ssp.getScienceGoal();
    }

    @Override
    public int getColumnCount() {
        return SpectralLineSetupCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return SpectralLineSetupCols.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.tuningInfo == null) {
            return null;
        }
        ScienceSpectralWindow scienceSpectralWindow = this.tuningInfo.sortedWindowList.get(n);
        if (scienceSpectralWindow == null) {
            return null;
        }
        CorrConfigMode corrConfigMode = scienceSpectralWindow.getCorrConfigMode();
        SpectralLineSetupCols spectralLineSetupCols = SpectralLineSetupCols.getColumnDescriptor(n2);
        switch (spectralLineSetupCols.ordinal()) {
            case 0: {
                return scienceSpectralWindow.getGroupIndex() + 1;
            }
            case 1: {
                return scienceSpectralWindow.getCenterFrequency().getContentInGHz();
            }
            case 2: {
                return scienceSpectralWindow.getTransitionName();
            }
            case 3: {
                return corrConfigMode.getEffectiveChannels();
            }
            case 4: {
                return corrConfigMode.getEffectiveBandwidth();
            }
            case 5: {
                return corrConfigMode.getEffectiveResolution(scienceSpectralWindow.getAdvancedWindowSetup());
            }
            case 6: 
            case 7: {
                Frequency frequency = spectralLineSetupCols == SpectralLineSetupCols.VELWIDTH ? scienceSpectralWindow.getEffectiveBandwidth() : corrConfigMode.getEffectiveResolution(scienceSpectralWindow.getAdvancedWindowSetup());
                return Speed.getSpeedResolution(frequency, scienceSpectralWindow.getCenterFrequencySky());
            }
            case 8: {
                ExpectedPropertiesElements expectedPropertiesElements = this.getScienceGoal().getConsolidatedExpectedProperties();
                UserFrequency userFrequency = expectedPropertiesElements.expectedLineWidth;
                Velocity velocity = expectedPropertiesElements.velocity;
                double d = scienceSpectralWindow.getVelocityResolutionInSky(velocity);
                return userFrequency.getContentInUnits(UserFrequency.USERUNIT_KM_S) / d;
            }
        }
        return null;
    }

    public String[] getLongValues() {
        return this.longValues;
    }

    public static enum SpectralLineSetupCols {
        BASEBAND("<html>&nbsp;BB&nbsp;<br>&nbsp;</html>", Integer.class),
        RESTFREQUENCY("<html>Center Freq<br>Rest GHz</html>", Double.class),
        LINEID("spw name", String.class),
        NCHANNELS("<html>&nbsp;Eff #Ch&nbsp;<br>&nbsp;p.p.</html>", Integer.class),
        BANDWIDTH("Bandwidth", Frequency.class),
        RESOLUTION("Resolution", Frequency.class),
        VELWIDTH("Vel. Bandwidth", Speed.class),
        VELRES("Vel. Res.", Speed.class),
        RESEL("<html>Res. El.<br>per FWHM</html>", String.class);

        private final String columnName;
        private final Class<?> columnClass;

        protected static int getColumnCount() {
            return SpectralLineSetupCols.values().length;
        }

        protected static SpectralLineSetupCols getColumnDescriptor(int n) {
            return SpectralLineSetupCols.values()[n];
        }

        private SpectralLineSetupCols(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

