/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.services.summaryfeedback.JointProposalSummaryView;
import alma.obsprep.services.summaryfeedback.TextPanelHelper;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.NonNull;

public class JointProposalCoverSheetExporter
extends DefaultPdfExporter {
    private static final String pageHeaderText = "Joint Proposal Technical Justifications";
    @NonNull
    private final JointProposalSummaryView jointProposalSummaryFeedbackView;

    public JointProposalCoverSheetExporter(@NonNull JointProposalSummaryView jointProposalSummaryView) {
        super(jointProposalSummaryView);
        if (jointProposalSummaryView == null) {
            throw new NullPointerException("offlinePDFView is marked non-null but is null");
        }
        this.jointProposalSummaryFeedbackView = jointProposalSummaryView;
    }

    private int addJointProposalTJSubpanels(JointProposalSummaryView jointProposalSummaryView, @NonNull Document document, @NonNull PdfWriter pdfWriter, int n) {
        if (document == null) {
            throw new NullPointerException("pdfDocument is marked non-null but is null");
        }
        if (pdfWriter == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        List<JointProposalSummaryView.PartnerFIDGrouping> list = JointProposalSummaryView.getFidPartnerGrouping();
        if (list == null || list.isEmpty() || list.stream().noneMatch(partnerFIDGrouping -> jointProposalSummaryView.getComponent(partnerFIDGrouping.getJustificationTextAreaFID()).isVisible())) {
            return n;
        }
        TextPanelHelper textPanelHelper = new TextPanelHelper(this, 1000, 350);
        textPanelHelper.createPage(pageHeaderText);
        int n2 = textPanelHelper.pageHeight;
        for (JointProposalSummaryView.PartnerFIDGrouping object : list) {
            JComponent jComponent = jointProposalSummaryView.getComponent(object.getJustificationTextAreaFID());
            jComponent.setBorder(BorderFactory.createTitledBorder(null, object.getJustificationBorderLabelText(), 0, 0, null, TextPanelHelper.titleColor));
            if ((n2 = this.fitTextIntoAvailableSpaceInTextPanel(textPanelHelper, jComponent, n2, pageHeaderText)) != 0) continue;
            textPanelHelper.createPage(pageHeaderText);
        }
        for (JComponent jComponent : textPanelHelper.textPages) {
            this.addPanelToPDFDocument(pdfWriter, jComponent);
            n = this.addNewPage(document, n);
        }
        return n;
    }

    @Override
    protected void exportToPdfPage(@NonNull Document document, @NonNull PdfWriter pdfWriter, Rectangle rectangle) {
        if (document == null) {
            throw new NullPointerException("pdfDocument is marked non-null but is null");
        }
        if (pdfWriter == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        if (this.jointProposalSummaryFeedbackView == null) {
            return;
        }
        int n = 0;
        PageSplitter pageSplitter = new PageSplitter(List.of(this.jointProposalSummaryFeedbackView.headerPanel));
        JLabel jLabel = new JLabel("Joint Proposals");
        Map<FieldID, Boolean> map = this.jointProposalSummaryFeedbackView.getTJUsedMap();
        this.jointProposalSummaryFeedbackView.setJointProposalJustificationVisibility(false);
        JPanel jPanel = this.addHeaderLabelToView(this.jointProposalSummaryFeedbackView, jLabel);
        this.doLayout(jPanel);
        for (int i = 0; i < pageSplitter.getNumberOfPages(); ++i) {
            pageSplitter.showPage(i);
            jLabel.setText("Joint Proposal Justifications");
            this.addPanelToPDFDocument(pdfWriter, jPanel);
            n = this.addNewPage(document, n);
        }
        this.jointProposalSummaryFeedbackView.restoreTJComponentVisibility(map);
        this.addJointProposalTJSubpanels(this.jointProposalSummaryFeedbackView, document, pdfWriter, n);
    }

    private class PageSplitter {
        @NonNull
        private final List<JPanel> allViews;
        private int pageIndex = -1;
        private final List<List<JPanel>> pages = new ArrayList<List<JPanel>>();

        public PageSplitter(List<JPanel> list) {
            if (list == null) {
                throw new NullPointerException("allViews is marked non-null but is null");
            }
            this.allViews = list;
            this.splitPages();
        }

        private int getNumberOfPages() {
            return this.pages.size();
        }

        private void setAllViewsVisible(boolean bl) {
            this.allViews.stream().forEach(jPanel -> jPanel.setVisible(bl));
        }

        private void setView() {
            if (this.pageIndex == -1) {
                this.setAllViewsVisible(true);
            } else {
                this.setAllViewsVisible(false);
                for (JPanel jPanel : this.pages.get(this.pageIndex)) {
                    jPanel.setVisible(true);
                }
            }
        }

        private void showPage(int n) {
            this.pageIndex = n;
            this.setView();
        }

        private void splitPages() {
            JPanel[][] jPanelArrayArray;
            JointProposalCoverSheetExporter.this.jointProposalSummaryFeedbackView.headerPanel.setVisible(true);
            for (JPanel[] jPanelArray : jPanelArrayArray = new JPanel[][]{{JointProposalCoverSheetExporter.this.jointProposalSummaryFeedbackView.headerPanel}}) {
                ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
                for (JPanel jPanel : jPanelArray) {
                    if (!jPanel.isVisible()) continue;
                    arrayList.add(jPanel);
                }
                if (arrayList.isEmpty()) continue;
                this.pages.add(arrayList);
            }
        }
    }
}

