/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionProviderInterface;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.summaryfeedback.SensitivityTableData;
import alma.obsprep.services.summaryfeedback.SummaryTableCellRendererFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.NonNull;

public class ARRangeSensitivityRenderer
extends SummaryTableCellRendererFactory.SummaryTableCellRenderer {
    @NonNull
    private final String fluxFormat;
    @NonNull
    private final String tempFormat;

    @Override
    String format(Object object) {
        if (!(object instanceof SensitivityTableData)) {
            return "Undefined";
        }
        SummaryTableCellRendererFactory summaryTableCellRendererFactory = new SummaryTableCellRendererFactory();
        SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = summaryTableCellRendererFactory.getSensitivityARRangeRenderer(this.fluxFormat, this.tempFormat);
        SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer2 = summaryTableCellRendererFactory.getSensitivityRenderer(this.fluxFormat, this.tempFormat);
        SensitivityTableData sensitivityTableData = (SensitivityTableData)object;
        ScienceGoal scienceGoal = sensitivityTableData.getScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        UserSensitivity userSensitivity = sensitivityTableData.getSensitivity().deepCopy();
        UserSensitivity userSensitivity2 = sensitivityTableData.getSensitivity().deepCopy();
        AngularResolutionMode angularResolutionMode = performanceParameters.getAngularResolutionMode();
        UserAngle userAngle = performanceParameters.getDesiredAngularResolution();
        switch (angularResolutionMode) {
            case Any: 
            case Range: {
                return this.formatRangeRelatedARModes(summaryTableCellRenderer, performanceParameters, userSensitivity, userSensitivity2);
            }
            case SACA: {
                return this.formatSACA(summaryTableCellRenderer2, scienceGoal, userSensitivity);
            }
            case Single: {
                userSensitivity.setBeamsize((Angle)((Object)userAngle));
                return summaryTableCellRenderer2.format(userSensitivity);
            }
        }
        throw new RuntimeException("Unknown AR mode " + String.valueOf(angularResolutionMode));
    }

    private String formatRangeRelatedARModes(@NonNull SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer, @NonNull PerformanceParameters performanceParameters, @NonNull UserSensitivity userSensitivity, @NonNull UserSensitivity userSensitivity2) {
        if (summaryTableCellRenderer == null) {
            throw new NullPointerException("sensitivityRangeRenderer is marked non-null but is null");
        }
        if (performanceParameters == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        if (userSensitivity == null) {
            throw new NullPointerException("sensitivityA is marked non-null but is null");
        }
        if (userSensitivity2 == null) {
            throw new NullPointerException("sensitivityB is marked non-null but is null");
        }
        try {
            boolean bl = performanceParameters.getDesiredSensitivity().inFluxUnit();
            String string = bl ? UserSensitivity.USERUNIT_JY : UserSensitivity.USERUNIT_K;
            UserAngle userAngle = SfiControlParameterModel.getARForFirstSensitivityFeedbackField(string, performanceParameters);
            UserAngle userAngle2 = SfiControlParameterModel.getARForSecondSensitivityFeedbackField(string, performanceParameters);
            assert (userAngle != null && userAngle2 != null);
            userSensitivity.setBeamsize((Angle)((Object)userAngle));
            userSensitivity2.setBeamsize((Angle)((Object)userAngle2));
            return summaryTableCellRenderer.format(new ArrayList<UserSensitivity>(Arrays.asList(userSensitivity, !bl ? SfiControlParameterModel.getFieldTwoSensitivityEquivalenceInK(performanceParameters) : userSensitivity2)));
        }
        catch (AngularResolutionProviderInterface.UnableToDetermineResolutionsException unableToDetermineResolutionsException) {
            Log.logger(ARRangeSensitivityRenderer.class).warning("Unable to get ARs " + unableToDetermineResolutionsException.getMessage());
            return "Unknown";
        }
    }

    private String formatSACA(SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer, ScienceGoal scienceGoal, UserSensitivity userSensitivity) {
        UserAngle userAngle;
        try {
            Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
            Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
            userAngle = UserAngle.createUserAngle(configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), Angle.UNIT_ARCSEC);
            userAngle.setObservingFrequency(frequency);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger((Object)this).info("Unable to determine configuration for ACA 7-m : " + invalidConfigurationParametersException.getMessage());
            return "Undefined";
        }
        userSensitivity.setBeamsize((Angle)((Object)userAngle));
        return summaryTableCellRenderer.format(userSensitivity);
    }

    public static ARRangeSensitivityRendererBuilder builder() {
        return new ARRangeSensitivityRendererBuilder();
    }

    public ARRangeSensitivityRenderer(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new NullPointerException("fluxFormat is marked non-null but is null");
        }
        if (string2 == null) {
            throw new NullPointerException("tempFormat is marked non-null but is null");
        }
        this.fluxFormat = string;
        this.tempFormat = string2;
    }

    public static class ARRangeSensitivityRendererBuilder {
        private String fluxFormat;
        private String tempFormat;

        ARRangeSensitivityRendererBuilder() {
        }

        public ARRangeSensitivityRendererBuilder fluxFormat(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("fluxFormat is marked non-null but is null");
            }
            this.fluxFormat = string;
            return this;
        }

        public ARRangeSensitivityRendererBuilder tempFormat(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("tempFormat is marked non-null but is null");
            }
            this.tempFormat = string;
            return this;
        }

        public ARRangeSensitivityRenderer build() {
            return new ARRangeSensitivityRenderer(this.fluxFormat, this.tempFormat);
        }

        public String toString() {
            return "ARRangeSensitivityRenderer.ARRangeSensitivityRendererBuilder(fluxFormat=" + this.fluxFormat + ", tempFormat=" + this.tempFormat + ")";
        }
    }
}

