/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.submission;

import java.io.File;
import java.util.List;

public class Data {

    public static class PartialReplyData {
        public static final int SC_PARTIAL_PROGRESS = 120;
        public int totalSteps;
        public int currentStep;
        public String message;

        public String toString() {
            return "Progress: " + this.message + " (" + this.currentStep + " out of " + this.totalSteps + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof PartialReplyData)) {
                return false;
            }
            PartialReplyData partialReplyData = (PartialReplyData)object;
            return partialReplyData.currentStep == this.currentStep && partialReplyData.totalSteps == this.totalSteps && (partialReplyData.message == null && this.message == null || partialReplyData.message != null && this.message != null && partialReplyData.message.equals(this.message));
        }

        public int hashCode() {
            int n = 17;
            n = n * 31 + this.currentStep;
            n = n * 31 + this.totalSteps;
            n = n * 31 + (this.message == null ? 0 : this.message.hashCode());
            return n;
        }
    }

    public static class DeleteResponseData
    extends ResponseData {
        public String success;

        public DeleteResponseData(int n, String string, String string2) {
            this.status = n;
            this.success = string;
            this.message = string2;
        }
    }

    public static class RetrieveResponseData
    extends ResponseData {
        public byte[] projectfile;

        public RetrieveResponseData(int n, byte[] byArray, String string) {
            this.status = n;
            this.projectfile = byArray;
            this.message = string;
        }
    }

    public static class Query2ResponseData
    extends ResponseData {
        public static final int USER_ROLE_ON_PROJ_IDX = 7;
        public static final String PI_COI = "PI/COI";
        public static final String CONTACT_SCIENTIST = "CS";
        public static final String PHASE2_DELEGEE = "Phase2Delegee";
        public String[][] fields;

        public Query2ResponseData(int n, String[][] stringArray, String string) {
            this.status = n;
            this.fields = stringArray;
            this.message = string;
        }
    }

    public static class QueryResponseData
    extends ResponseData {
        public String[] descriptions;

        public QueryResponseData(int n, String[] stringArray, String string) {
            this.status = n;
            this.descriptions = stringArray;
            this.message = string;
        }
    }

    public static class StoreResponseData
    extends ResponseData {
        public static final int SC_VALIDATION_WARNINGS = 201;
        public static final int SC_CONFLICT = 409;
        public static final int SC_EXPECTATION_FAILED = 417;
        public static final int SC_VALIDATION_FAILED = 422;
        public static final int SC_OUTSIDE_DEADLINE = 423;
        public byte[] projectfile;

        public StoreResponseData(int n, byte[] byArray, String string) {
            this.status = n;
            this.projectfile = byArray;
            this.message = string;
        }
    }

    public static class ResponseData {
        public static final int SC_OK = 200;
        public static final int SC_BAD_REQUEST = 400;
        public static final int SC_UNAUTHORIZED = 401;
        public static final int SC_FORBIDDEN = 403;
        public static final int SC_NOT_FOUND = 404;
        public static final int SC_NOT_ACCEPTABLE = 406;
        public static final int SC_INTERNAL_SERVER_ERROR = 500;
        public static final int SC_SERVICE_UNAVAILABLE = 503;
        public static final int SC_SERVER_FAILURE = 555;
        public int status;
        public String message;
    }

    public static class DeleteRequestData
    extends RequestData {
        public String projectId;
    }

    public static class RetrieveRequestData
    extends RequestData {
        public String retrieveVariant;
        public String projectId;
    }

    public static class Query2RequestData
    extends RequestData {
        public static final String ALL_MY_PROJECTS = "__{RequestingUser}__";
        public static final int searchForPI = 0;
        public static final int searchForPICOI = 1;
        public static final int searchForProjectName = 2;
        public static final int searchForProjectCode = 3;
        public static final int searchForProjectStatus = 4;
        public int searchVariant;
        public String searchString;
        public boolean caseSensitive;
        public boolean containsString;
    }

    public static class QueryRequestData
    extends RequestData {
        public static final String ALL_MY_PROJECTS = "__ALLMYPIANDCOIPROJECTSPLEASE__";
        public String predicate;
        public boolean includeStatus;
    }

    public static class StoreRequestData
    extends RequestData {
        public String store;
        public List<File> files;
    }

    public static class RequestData {
    }
}

