/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.specialsb;

import alma.acs.entityutil.EntityDeserializer;
import alma.acs.entityutil.EntityException;
import alma.acs.entityutil.EntityRefFinder;
import alma.acs.entityutil.EntitySerializer;
import alma.entities.commonentity.EntityRefT;
import alma.entities.commonentity.EntityT;
import alma.entity.xmlbinding.obsproject.ObsProjectEntityT;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.services.specialsb.ISpecialProjectBuilder;
import alma.obsprep.services.specialsb.ISpecialSchedBlockBuilder;
import alma.obsprep.services.specialsb.SpecialSchedBlockBuilder;
import alma.xmlentity.XmlEntityStruct;
import java.util.Vector;
import java.util.logging.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class SpecialProjectBuilder
implements ISpecialProjectBuilder {
    private Logger log;
    private ObsProject bo;

    protected SpecialProjectBuilder(Logger logger) {
        this.log = logger;
        this.createAsEmpty();
    }

    protected SpecialProjectBuilder(Logger logger, XmlEntityStruct xmlEntityStruct) throws MarshalException, ValidationException, EntityException {
        this.log = logger;
        this.materialize(xmlEntityStruct);
    }

    protected SpecialProjectBuilder(Logger logger, ObsProject obsProject) {
        this.log = logger;
        this.setBo(obsProject);
    }

    protected ObsProject getBo() {
        return this.bo;
    }

    private void setBo(ObsProject obsProject) {
        ObsUnitSet[] obsUnitSetArray = obsProject.getObsProgram().getObsPlan().getObsUnitSet();
        if (obsUnitSetArray.length == 0) {
            obsProject.getObsProgram().getObsPlan().addObsUnitSet(ObsUnitSet.createObsUnitSet());
        }
        this.bo = obsProject;
    }

    public String getPi() {
        return this.bo.getPI();
    }

    public void setPi(String string) {
        this.bo.setPI(string);
    }

    public String getProjectName() {
        return this.bo.getProjectName();
    }

    public void setProjectName(String string) {
        this.bo.setProjectName(string);
    }

    public void addSchedBlock(ISpecialSchedBlockBuilder iSpecialSchedBlockBuilder) {
        SpecialSchedBlockBuilder specialSchedBlockBuilder = (SpecialSchedBlockBuilder)iSpecialSchedBlockBuilder;
        ObsUnitSet obsUnitSet = this.bo.getObsProgram().getObsPlan().getObsUnitSet(0);
        obsUnitSet.addSchedBlock(specialSchedBlockBuilder.getBo());
    }

    public void removeSchedBlock(ISpecialSchedBlockBuilder iSpecialSchedBlockBuilder) {
        SpecialSchedBlockBuilder specialSchedBlockBuilder = (SpecialSchedBlockBuilder)iSpecialSchedBlockBuilder;
        ObsUnitSet obsUnitSet = this.bo.getObsProgram().getObsPlan().getObsUnitSet(0);
        obsUnitSet.removeSchedBlock(specialSchedBlockBuilder.getBo());
    }

    public SpecialSchedBlockBuilder[] getSchedBlocks() throws UnknownEntityException {
        ObsUnitSet obsUnitSet = this.bo.getObsProgram().getObsPlan().getObsUnitSet(0);
        SchedBlock[] schedBlockArray = obsUnitSet.getSchedBlock();
        SpecialSchedBlockBuilder[] specialSchedBlockBuilderArray = new SpecialSchedBlockBuilder[schedBlockArray.length];
        for (int i = 0; i < specialSchedBlockBuilderArray.length; ++i) {
            specialSchedBlockBuilderArray[i] = new SpecialSchedBlockBuilder(this.log, schedBlockArray[i]);
        }
        return specialSchedBlockBuilderArray;
    }

    public String[] getSchedBlockIds() throws EntityException {
        EntityRefT[] entityRefTArray;
        Vector<String> vector = new Vector<String>();
        EntityRefFinder entityRefFinder = new EntityRefFinder();
        alma.entity.xmlbinding.obsproject.ObsProject obsProject = this.bo.getCastorObject();
        for (EntityRefT entityRefT : entityRefTArray = entityRefFinder.findEntityReferences((Object)obsProject)) {
            if (!entityRefT.getEntityTypeName().equals("SchedBlock")) continue;
            vector.add(entityRefT.getEntityId());
        }
        return vector.toArray(new String[vector.size()]);
    }

    private void createAsEmpty() {
        ObsProject obsProject = ObsProject.createObsProject();
        this.setBo(obsProject);
    }

    public XmlEntityStruct serialize() throws EntityException {
        alma.entity.xmlbinding.obsproject.ObsProject obsProject = this.bo.getCastorObject();
        ObsProjectEntityT obsProjectEntityT = obsProject.getObsProjectEntity();
        obsProjectEntityT.setDocumentVersion("1");
        obsProjectEntityT.setSchemaVersion("1");
        EntitySerializer entitySerializer = EntitySerializer.getEntitySerializer((Logger)this.log);
        XmlEntityStruct xmlEntityStruct = entitySerializer.serializeEntity((Object)obsProject, (EntityT)obsProjectEntityT);
        return xmlEntityStruct;
    }

    private void materialize(XmlEntityStruct xmlEntityStruct) throws MarshalException, ValidationException, EntityException {
        EntityDeserializer entityDeserializer = EntityDeserializer.getEntityDeserializer((Logger)this.log);
        alma.entity.xmlbinding.obsproject.ObsProject obsProject = (alma.entity.xmlbinding.obsproject.ObsProject)entityDeserializer.deserializeEntity(xmlEntityStruct, alma.entity.xmlbinding.obsproject.ObsProject.class);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.getInstance().adopt(obsProject, null, null, null, null);
        this.setBo(boBundle.boProject);
    }
}

