/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network.versioncheck;

import alma.obsprep.services.network.NetworkService;
import alma.obsprep.services.network.exceptions.ConnectionException;
import alma.obsprep.services.network.versioncheck.NullVersionChecker;
import alma.obsprep.services.network.versioncheck.VersionCheckResult;
import alma.obsprep.services.network.versioncheck.VersionChecker;
import alma.obsprep.services.network.versioncheck.WebServiceVersionChecker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class VersionCheckerService
implements NetworkService,
VersionChecker {
    private static final String WEBAPP_URL = "/ObsprepSubmissionService/VersionCheck";
    private URL url;
    private VersionChecker checker;

    public boolean setUrl(String string) throws MalformedURLException {
        if (string != null) {
            boolean bl = false;
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String string2 = string + WEBAPP_URL;
            if (this.url == null || !string2.equals(this.url.toString())) {
                try {
                    this.url = new URL(string2);
                    bl = false;
                }
                catch (MalformedURLException malformedURLException) {
                    this.url = null;
                    throw malformedURLException;
                }
            } else {
                bl = true;
            }
            return !bl;
        }
        return false;
    }

    @Override
    public void goOnline() throws ConnectionException {
        try {
            this.checker = this.url == null ? new NullVersionChecker() : new WebServiceVersionChecker(this.url);
        }
        catch (IOException iOException) {
            this.checker = new NullVersionChecker();
        }
    }

    @Override
    public VersionCheckResult check(String string) throws IOException {
        return this.checker.check(string);
    }
}

