/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions.wrappers;

import alma.Control.BasebandSpec;
import alma.Control.DSBbasebandSpec;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.BasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.valuetypes.Frequency;

public class DSBbasebandSpecWrapper
extends AbstractBasebandSpecWrapper {
    private SidebandSelectWrapper sidebandSelect = SidebandSelectWrapper.Either;
    private BasebandSpecWrapper primarySpec;
    private BasebandSpecWrapper subSpec;

    public DSBbasebandSpecWrapper() {
    }

    public DSBbasebandSpecWrapper(BasebandSpecWrapper basebandSpecWrapper, BasebandSpecWrapper basebandSpecWrapper2) {
        this.primarySpec = basebandSpecWrapper;
        this.subSpec = basebandSpecWrapper2;
    }

    public DSBbasebandSpecWrapper(DSBbasebandSpec dSBbasebandSpec) {
        this();
        this.importNativeBasebandSpec(dSBbasebandSpec);
    }

    @Override
    public void importNativeBasebandSpec(Object object) {
        if (!(object instanceof DSBbasebandSpec)) {
            throw new IllegalArgumentException("Must be an instance of DSBbasebandSpec");
        }
        DSBbasebandSpec dSBbasebandSpec = (DSBbasebandSpec)object;
        this.getPrimarySpec().importNativeBasebandSpec(dSBbasebandSpec.LSB);
        this.getSubSpec().importNativeBasebandSpec(dSBbasebandSpec.USB);
    }

    public DSBbasebandSpec exportNativeBasebandSpec() {
        DSBbasebandSpec dSBbasebandSpec = new DSBbasebandSpec();
        switch (this.sidebandSelect) {
            case Either: {
                dSBbasebandSpec.LSB = this.getPrimarySpec().exportNativeBasebandSpec();
                dSBbasebandSpec.USB = this.getPrimarySpec().exportNativeBasebandSpec();
                return dSBbasebandSpec;
            }
            case Lower: {
                dSBbasebandSpec.LSB = this.getPrimarySpec().exportNativeBasebandSpec();
                dSBbasebandSpec.USB = new BasebandSpec(0.0, 0.0, 0.0);
                return dSBbasebandSpec;
            }
            case Upper: {
                dSBbasebandSpec.LSB = new BasebandSpec(0.0, 0.0, 0.0);
                dSBbasebandSpec.USB = this.getPrimarySpec().exportNativeBasebandSpec();
                return dSBbasebandSpec;
            }
            case Both: {
                if (this.getSubSpec().getSkyFrequency().compareTo((AbstractDoubleWithUnit)this.getPrimarySpec().getSkyFrequency()) > 0) {
                    dSBbasebandSpec.LSB = this.getPrimarySpec().exportNativeBasebandSpec();
                    dSBbasebandSpec.USB = this.getSubSpec().exportNativeBasebandSpec();
                } else {
                    dSBbasebandSpec.USB = this.getPrimarySpec().exportNativeBasebandSpec();
                    dSBbasebandSpec.LSB = this.getSubSpec().exportNativeBasebandSpec();
                }
                return dSBbasebandSpec;
            }
        }
        return dSBbasebandSpec;
    }

    @Override
    public void setOneSkyFrequency(Frequency frequency) {
        this.setSidebandSelect(SidebandSelectWrapper.Either);
        BasebandSpecWrapper basebandSpecWrapper = this.getPrimarySpec();
        basebandSpecWrapper.setSkyFrequency(frequency);
    }

    public BasebandSpecWrapper getPrimarySpec() {
        if (this.primarySpec == null) {
            this.primarySpec = new BasebandSpecWrapper();
        }
        return this.primarySpec;
    }

    public BasebandSpecWrapper getSubSpec() {
        if (this.subSpec == null) {
            this.subSpec = new BasebandSpecWrapper();
        }
        return this.subSpec;
    }

    public SidebandSelectWrapper getSidebandSelect() {
        return this.sidebandSelect;
    }

    public void setSidebandSelect(SidebandSelectWrapper sidebandSelectWrapper) {
        this.sidebandSelect = sidebandSelectWrapper;
    }
}

