/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.targetcreator.ITargetCreatorHelper;
import alma.obsprep.services.generator.refactored.targetcreator.ObservatoryGoalTargetCreatorFactory;
import alma.obsprep.services.generator.refactored.targetcreator.ScienceGoalTargetCreatorFactory;
import lombok.NonNull;

public class TargetCreatorHelper {
    private TargetCreatorHelper() {
    }

    public static ITargetCreatorHelper getFactory(@NonNull RequestedArray requestedArray, @NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, int n, @NonNull SBGenerationContext sBGenerationContext) {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)spectralSetupParameters.getParent();
        if (abstractScienceGoal instanceof ObservatoryGoal) {
            return new ObservatoryGoalTargetCreatorFactory(requestedArray, targetWithIntent, spectralSetupParameters, n, sBGenerationContext);
        }
        if (abstractScienceGoal instanceof ScienceGoal) {
            return new ScienceGoalTargetCreatorFactory(requestedArray, targetWithIntent, spectralSetupParameters, n, sBGenerationContext);
        }
        throw new IllegalArgumentException("SpectralSetupParameters must belong to a ScienceGoal or ObservatoryGoal");
    }
}

