/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.ObservingParametersAbstractFactory;
import alma.obsprep.services.generator.refactored.obsparams.ObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.ObservatoryGoalSpectralSpecWorker;
import alma.obsprep.services.generator.refactored.targetcreator.ITargetCreatorHelper;
import alma.valuetypes.Time;

class ObservatoryGoalTargetCreatorFactory
implements ITargetCreatorHelper {
    private final ObservingParameters observingParameters;
    private final SpectralSpec spectralSpec;

    public ObservatoryGoalTargetCreatorFactory(RequestedArray requestedArray, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, int n, SBGenerationContext sBGenerationContext) {
        BusinessObject businessObject = spectralSetupParameters.getParent();
        if (!(businessObject instanceof ObservatoryGoal)) {
            throw new IllegalArgumentException("SpectralSetupParameters must belong to an ObservatoryGoal");
        }
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)businessObject;
        Time time = observatoryGoal.getIntegrationTime();
        ObservatoryGoalSpectralSpecWorker observatoryGoalSpectralSpecWorker = new ObservatoryGoalSpectralSpecWorker(spectralSetupParameters, time);
        this.spectralSpec = observatoryGoalSpectralSpecWorker.getSpectralSpec();
        ObservingParametersFactory observingParametersFactory = ObservingParametersAbstractFactory.getFactory(spectralSetupParameters, this.spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        this.observingParameters = observingParametersFactory.getObservingParameters(targetWithIntent.getObsType(), n, spectralSetupParameters, this.spectralSpec, sBGenerationContext);
    }

    @Override
    public ObservingParameters getObservingParameters() {
        return this.observingParameters;
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return this.spectralSpec;
    }
}

