/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.ReferencePositionOffset;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.etc.ClusterGeometricMeanCalculator;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import jsky.coords.WorldCoords;
import lombok.NonNull;

public class FieldSourceWorkers {
    @NonNull
    SpectralSpec spectralSpec;
    @NonNull
    FieldSource fieldSource;
    boolean isScienceTarget;
    private static final Collection<String> RASTER_TYPES = Collections.unmodifiableCollection(List.of(FieldPattern.TYPE_RECTANGLE));

    public Reference getAtmosphericReferencePosition() {
        Reference reference = Reference.createReference();
        reference.setCycleTime(Time.createTime((double)100.0, (String)Time.UNIT_H));
        reference.setIntegrationTime(Time.createTimeSec(4.0));
        reference.setReferenceCoordinates(this.getReferencePosition(this.fieldSource, this.spectralSpec));
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.spectralSpec.getCorrelatorConfiguration();
        Time time = abstractCorrelatorConfiguration.getIntegrationDuration();
        CorrelatorExpert correlatorExpert = this.spectralSpec.getCorrelatorExpert();
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = correlatorExpert.calcSubscanDuration(2.0, d, null);
        reference.setSubScanDuration(Time.createTimeSec(d2));
        return reference;
    }

    private SkyCoordinates getReferencePosition(@NonNull FieldSource fieldSource, SpectralSpec spectralSpec) {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        String string = fieldSource.getFieldPatternType();
        boolean bl = RASTER_TYPES.contains(string);
        boolean bl2 = false;
        FieldPattern fieldPattern = fieldSource.getFieldPattern();
        if (fieldPattern instanceof PointingPattern) {
            PointingPattern pointingPattern = (PointingPattern)((Object)fieldPattern);
            boolean bl3 = bl2 = pointingPattern.getNumberOfPointings() == 1;
        }
        if (this.isScienceTarget) {
            boolean bl4 = fieldSource.isSolar();
            boolean bl5 = fieldSource.getNonSiderealMotion() && !bl4;
            int n = spectralSpec.getReceiverBand().getNumber();
            if (bl4) {
                return this.getSolarReferencePosition(n);
            }
            if (bl5) {
                try {
                    return this.getNonSiderealReferencePosition(n, fieldSource.getSolarSystemObject());
                }
                catch (OTConfigurationHelper.UnableToMapSiderealObjectException unableToMapSiderealObjectException) {
                    Log.logger(FieldSourceWorkers.class).fine("Unable to find XML reference position for " + fieldSource.getSolarSystemObject() + " at band " + n);
                    return this.getDefaultReferencePosition(n);
                }
            }
            if (bl) {
                return this.getRasterReferencePosition(fieldSource);
            }
            if (bl2) {
                return this.getSinglePointingReferencePosition(spectralSpec);
            }
            return FieldSourceWorkers.getMosaicSpecificReferencePosition(fieldSource, n);
        }
        if (bl2) {
            return this.getSinglePointingReferencePosition(spectralSpec);
        }
        return this.getDefaultReferencePosition(spectralSpec.getReceiverBand().getNumber());
    }

    private SkyCoordinates getNonSiderealReferencePosition(int n, @NonNull String string) throws OTConfigurationHelper.UnableToMapSiderealObjectException {
        if (string == null) {
            throw new NullPointerException("solarSystemObject is marked non-null but is null");
        }
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        try {
            AlmaCapabilities.ReferenceOffset referenceOffset = AlmaCapabilities.getInstance().getNonSiderealInterferometricReferenceOffset(ReferencePositionOffset.NON_SIDEREAL, string, n);
            skyCoordinates.setCoordinates(referenceOffset.latitude(), referenceOffset.longitude());
        }
        catch (AlmaCapabilities.UnableToFindOffsetException unableToFindOffsetException) {
            skyCoordinates = this.getDefaultReferencePosition(n);
            Log.logger(FieldSourceWorkers.class).warning("Cannot find reference position for non-sidereal source with B" + n);
        }
        return skyCoordinates;
    }

    public static SkyCoordinates getMosaicSpecificReferencePosition(@NonNull FieldSource fieldSource, int n) {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        Object object = fieldSource.getFieldPattern();
        if (!(object instanceof PointingPattern)) {
            throw new WizardSBGenerationException("Field source should be pointing pattern");
        }
        PointingPattern pointingPattern = (PointingPattern)object;
        if (Log.logger(FieldSourceWorkers.class).finer()) {
            Stream.of(pointingPattern.getPhaseCenterCoordinates()).map(skyCoordinates -> skyCoordinates.getAbsoluteCoordinates(fieldSource.getTargetCenter())).forEach(System.out::println);
        }
        object = Stream.of(pointingPattern.getPhaseCenterCoordinates()).map(skyCoordinates -> new ScienceGoal.SourcePoint(null, skyCoordinates.getAbsoluteCoordinates(fieldSource.getTargetCenter()).getAbsoluteSkyPointInICRSDeg())).toList();
        SkyCoordinates skyCoordinates2 = new ClusterGeometricMeanCalculator().getMeanGeometricCoordinates((List<ScienceGoal.SourcePoint>)object);
        Angle angle = (Angle)FieldSourceWorkers.getMaxAngularSeparation((List<ScienceGoal.SourcePoint>)object).divide(2.0);
        Angle angle2 = (Angle)angle.plus((AbstractDoubleWithUnit)Angle.createAngle((double)(n >= 1 && n <= 3 ? 10.0 : 2.0), (String)Angle.UNIT_ARCMIN));
        Longitude longitude = (Longitude)skyCoordinates2.getLongitude().plus((AbstractDoubleWithUnit)Longitude.createLongitude((double)angle2.getArcmin(), (String)Longitude.UNIT_ARCMIN));
        if (longitude.getDegs() > 360.0) {
            longitude.setContentAndUnit(longitude.getDegs() % 360.0, Longitude.UNIT_DEG);
        }
        skyCoordinates2.setLongitude(longitude);
        skyCoordinates2.setSystem(SkyCoordinates.SYSTEM_ICRS);
        return skyCoordinates2;
    }

    public static Angle getMaxAngularSeparation(@NonNull List<ScienceGoal.SourcePoint> list) {
        if (list == null) {
            throw new NullPointerException("sourcePoints is marked non-null but is null");
        }
        if (list.isEmpty()) {
            throw new WizardSBGenerationException("sourcePoints is empty");
        }
        Angle angle = null;
        for (ScienceGoal.SourcePoint sourcePoint : list) {
            SkyPoint skyPoint = sourcePoint.getSkyPoint();
            for (ScienceGoal.SourcePoint sourcePoint2 : list) {
                if (sourcePoint.equals(sourcePoint2)) continue;
                SkyPoint skyPoint2 = sourcePoint2.getSkyPoint();
                Angle angle2 = Angle.createAngleDegs(WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0);
                if (angle != null && !angle.isLessThan((AbstractDoubleWithUnit)angle2)) continue;
                angle = angle2;
            }
        }
        if (angle == null) {
            throw new WizardSBGenerationException("Unable to calculate the largest separation");
        }
        return angle;
    }

    private SkyCoordinates getSolarReferencePosition(int n) {
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        try {
            AlmaCapabilities.ReferenceOffset referenceOffset = AlmaCapabilities.getInstance().getInterferometricReferenceOffset(ReferencePositionOffset.SOLAR, n);
            skyCoordinates.setCoordinates(referenceOffset.latitude(), referenceOffset.longitude());
        }
        catch (AlmaCapabilities.UnableToFindOffsetException unableToFindOffsetException) {
            skyCoordinates = this.getDefaultReferencePosition(n);
            Log.logger(FieldSourceWorkers.class).warning("Cannot find reference position for single pointing with B" + n + " for solar");
        }
        return skyCoordinates;
    }

    private SkyCoordinates getSinglePointingReferencePosition(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        int n = spectralSpec.getReceiverBand().getNumber();
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        try {
            AlmaCapabilities.ReferenceOffset referenceOffset = AlmaCapabilities.getInstance().getInterferometricReferenceOffset(ReferencePositionOffset.SINGLE_POINTING, n);
            skyCoordinates.setCoordinates(referenceOffset.latitude(), referenceOffset.longitude());
        }
        catch (AlmaCapabilities.UnableToFindOffsetException unableToFindOffsetException) {
            skyCoordinates = this.getDefaultReferencePosition(n);
            Log.logger(FieldSourceWorkers.class).warning("Cannot find reference position for single pointing with B" + n);
        }
        return skyCoordinates;
    }

    private SkyCoordinates getRasterReferencePosition(@NonNull FieldSource fieldSource) {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        Angle angle = rectanglePattern.getLatitudeLength().deepCopy();
        Longitude longitude = Longitude.createLongitude((double)angle.getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
        skyCoordinates.setLongitude(longitude);
        return skyCoordinates;
    }

    private SkyCoordinates getDefaultReferencePosition(int n) {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        try {
            AlmaCapabilities.ReferenceOffset referenceOffset = almaCapabilities.getInterferometricReferenceOffset(ReferencePositionOffset.DEFAULT, n);
            skyCoordinates.setLatitude(referenceOffset.latitude());
            skyCoordinates.setLongitude(referenceOffset.longitude());
        }
        catch (AlmaCapabilities.UnableToFindOffsetException unableToFindOffsetException) {
            Log.logger(FieldSourceWorkers.class).warning("Unable to find default reference offset position for rxb " + n);
            skyCoordinates.setLongitude(Longitude.createLongitude((double)2.0, (String)Angle.UNIT_ARCMIN));
            skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
        }
        return skyCoordinates;
    }

    private static boolean $default$isScienceTarget() {
        return true;
    }

    FieldSourceWorkers(@NonNull SpectralSpec spectralSpec, @NonNull FieldSource fieldSource, boolean bl) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        this.spectralSpec = spectralSpec;
        this.fieldSource = fieldSource;
        this.isScienceTarget = bl;
    }

    public static FieldSourceWorkersBuilder builder() {
        return new FieldSourceWorkersBuilder();
    }

    public static class FieldSourceWorkersBuilder {
        private SpectralSpec spectralSpec;
        private FieldSource fieldSource;
        private boolean isScienceTarget$set;
        private boolean isScienceTarget$value;

        FieldSourceWorkersBuilder() {
        }

        public FieldSourceWorkersBuilder spectralSpec(@NonNull SpectralSpec spectralSpec) {
            if (spectralSpec == null) {
                throw new NullPointerException("spectralSpec is marked non-null but is null");
            }
            this.spectralSpec = spectralSpec;
            return this;
        }

        public FieldSourceWorkersBuilder fieldSource(@NonNull FieldSource fieldSource) {
            if (fieldSource == null) {
                throw new NullPointerException("fieldSource is marked non-null but is null");
            }
            this.fieldSource = fieldSource;
            return this;
        }

        public FieldSourceWorkersBuilder isScienceTarget(boolean bl) {
            this.isScienceTarget$value = bl;
            this.isScienceTarget$set = true;
            return this;
        }

        public FieldSourceWorkers build() {
            boolean bl = this.isScienceTarget$value;
            if (!this.isScienceTarget$set) {
                bl = FieldSourceWorkers.$default$isScienceTarget();
            }
            return new FieldSourceWorkers(this.spectralSpec, this.fieldSource, bl);
        }

        public String toString() {
            return "FieldSourceWorkers.FieldSourceWorkersBuilder(spectralSpec=" + String.valueOf(this.spectralSpec) + ", fieldSource=" + String.valueOf(this.fieldSource) + ", isScienceTarget$value=" + this.isScienceTarget$value + ")";
        }
    }
}

