/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.services.experts.MinBoundingBoxExpert;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.targetcreator.TargetParametersFieldSourceWorker;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import jsky.coords.WorldCoords;
import lombok.NonNull;

public class ACACustomMosaicPointingCalculator {
    private ACACustomMosaicPointingCalculator() {
    }

    public static void setupMinBoundingBoxACA7mPointingPattern(@NonNull TargetParameters targetParameters, @NonNull PointingPattern pointingPattern, @NonNull SpectralSetupParameters spectralSetupParameters) throws SpectralSetupParameters.CannotDetermineLowestFrequencyException {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pointingPattern7m is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        ACACustomMosaicPointingCalculator.getACA7mPointingPattern(targetParameters, pointingPattern, spectralSetupParameters.getLowestCentralFrequency());
    }

    static void setupMinBoundingBoxACA7mPointingPattern(@NonNull TargetParameters targetParameters, @NonNull PointingPattern pointingPattern, @NonNull SpectralSpec spectralSpec) {
        Frequency frequency;
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pointingPattern7m is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.LOWESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        assert (frequency != null);
        ACACustomMosaicPointingCalculator.getACA7mPointingPattern(targetParameters, pointingPattern, frequency);
    }

    private static void getACA7mPointingPattern(@NonNull TargetParameters targetParameters, @NonNull PointingPattern pointingPattern, @NonNull Frequency frequency) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pointingPattern7m is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("lowestSPWCentralFrequency is marked non-null but is null");
        }
        if (!targetParameters.getIsMosaic()) {
            throw new IllegalArgumentException("The target parameters are expected to be a custom mosaic");
        }
        Rectangle rectangle = MinBoundingBoxExpert.getBoundingRectangle(targetParameters);
        boolean bl = Log.logger(SchedBlockExpert.class).fine();
        if (bl) {
            Log.logger(SchedBlockExpert.class).fine("Raw 12-m rectangle bounding points: " + String.valueOf(rectangle));
        }
        Angle angle = Angle.createAngle();
        angle.setContent(frequency.getWavelengthM() / Antenna.ANTENNA_7M.getDiameter());
        angle.setUnit(Angle.UNIT_RAD);
        angle.convertToUnit(Angle.UNIT_ARCSEC);
        UserAngle userAngle = UserAngle.createUserAngle((Angle)angle.divide(Math.sqrt(3.0)));
        userAngle.setAntenna(Antenna.ANTENNA_7M);
        userAngle.setObservingFrequency(frequency);
        Angle angle2 = Antenna.ANTENNA_12M.getBeamSize(frequency);
        Angle angle3 = (Angle)rectangle.getLatitudeLength().plus((ValueUnitPair)angle2);
        Angle angle4 = (Angle)rectangle.getLongitudeLength().plus((ValueUnitPair)angle2);
        rectangle.setShort(angle3);
        rectangle.setLong(angle4);
        rectangle.setArray(Array.ARRAY_7M);
        rectangle.setReferenceFrequency(frequency);
        if (bl) {
            Log.logger(TargetParametersFieldSourceWorker.class).fine(String.format("Nyquist spacing for 7m at %s is %s or %s arcsec", frequency.toString(), userAngle.getContentInUnits(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM), userAngle.getContentInUnits(UserAngle.USERUNIT_ARCSEC)));
        }
        rectangle.setSpacing(UserAngle.createUserAngle((Angle)((Object)userAngle)));
        RectangleMosaic rectangleMosaic = new RectangleMosaic(rectangle, Antenna.ANTENNA_7M);
        PointingPattern pointingPattern2 = rectangleMosaic.getPointingPattern(targetParameters.getFieldCenterCoordinates().getICRSSkyCoordinates());
        if (pointingPattern2.getPhaseCenterCoordinatesCount() == 0) {
            pointingPattern2.addPhaseCenterCoordinates(SkyCoordinates.createOffsetCoordinates());
        }
        for (SkyCoordinates skyCoordinates : pointingPattern2.getPhaseCenterCoordinates()) {
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
        }
        pointingPattern.setIsMosaic(targetParameters.getIsMosaic());
        ACACustomMosaicPointingCalculator.eliminateRedundant7mPointingsFromPointingPattern(targetParameters, pointingPattern, frequency);
    }

    private static void eliminateRedundant7mPointingsFromPointingPattern(@NonNull TargetParameters targetParameters, @NonNull PointingPattern pointingPattern, @NonNull Frequency frequency) {
        Object object;
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pointingPattern is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("lowestSPWCentralFrequency is marked non-null but is null");
        }
        if (!targetParameters.getIsMosaic()) {
            throw new IllegalArgumentException("The target parameters should be a custom mosaic");
        }
        UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(Antenna.ANTENNA_7M);
        double d = userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC) / 2.0;
        assert (d > 0.0);
        boolean bl = Log.logger(ACACustomMosaicPointingCalculator.class).fine();
        if (bl) {
            Log.logger(ACACustomMosaicPointingCalculator.class).fine(String.format("beamWidth7mRadius=%g maxSeparationFrom12mPointing=%g", d, d));
        }
        ArrayList<SkyCoordinates> arrayList = new ArrayList<SkyCoordinates>(150);
        ArrayList<SkyPoint> arrayList2 = new ArrayList<SkyPoint>(150);
        for (SkyCoordinates skyCoordinates : targetParameters.getPointingPattern().getPhaseCenterCoordinates()) {
            object = skyCoordinates;
            if (!((SkyCoordinates)object).isAbsoluteCoordinates()) {
                object = skyCoordinates.deepCopy();
                object = ((SkyCoordinates)object).getAbsoluteCoordinates(targetParameters.getSourceCoordinates());
            }
            arrayList2.add(((SkyCoordinates)object).getAbsoluteSkyPointInICRSDeg());
        }
        block1: for (SkyCoordinates skyCoordinates : pointingPattern.getPhaseCenterCoordinates()) {
            object = new ArrayList(150);
            SkyCoordinates skyCoordinates2 = skyCoordinates;
            if (!skyCoordinates2.isAbsoluteCoordinates()) {
                skyCoordinates2 = skyCoordinates.deepCopy();
                skyCoordinates2 = skyCoordinates2.getAbsoluteCoordinates(targetParameters.getSourceCoordinates());
            }
            SkyPoint skyPoint = skyCoordinates2.getAbsoluteSkyPointInICRSDeg();
            boolean bl2 = false;
            for (SkyPoint skyPoint2 : arrayList2) {
                double d2 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) * 60.0;
                if (bl) {
                    Log.logger(TargetParametersFieldSourceWorker.class).fine("distanceSeparatingPointings (arcsec): " + d2);
                }
                if (d2 <= d) {
                    bl2 = true;
                    continue block1;
                }
                ((ArrayList)object).add(d2);
            }
            if (bl2) continue;
            arrayList.add(skyCoordinates);
        }
        arrayList.stream().forEach(arg_0 -> ((PointingPattern)pointingPattern).removePhaseCenterCoordinates(arg_0));
        if (bl) {
            Log.logger(TargetParametersFieldSourceWorker.class).fine(String.format("%d pointings in the 7m pointing pattern: %d have been removed)", pointingPattern.getNumberOfPointings(), arrayList.size()));
        }
    }
}

