/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.ACADGCB2BReferenceSpectralSpecBuilder;
import alma.obsprep.services.generator.refactored.spectralspec.BLDGCB2BReferenceSpectralSpecBuilder;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecWorker;
import java.util.Optional;
import lombok.NonNull;

public class DGCReferenceB2BSpectralSpecBuilderFactory {
    public static DGCReferenceB2BBuilderInterface getDGCReferenceB2BSpectralSpecBuilder(@NonNull SpectralSpec spectralSpec, @NonNull Optional<SBGenerationContext> optional) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        if (spectralSpec.isACASpectralSpec()) {
            return new ACADGCB2BReferenceSpectralSpecBuilder(optional);
        }
        if (spectralSpec.isBLSpectralSpec()) {
            return new BLDGCB2BReferenceSpectralSpecBuilder(optional);
        }
        throw new WizardSBGenerationException("Unable to create DGCReferenceMerger - unknown correlator type");
    }

    public static interface DGCReferenceB2BBuilderInterface {
        public SpectralSpec createDGCReferenceB2BSpectralSpec(@NonNull SpectralSpec var1, @NonNull SpectralSetupParameters var2, @NonNull SpectralSpecWorker var3);
    }
}

