/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupFactory;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BFrequencySetup;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecWorker;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public abstract class DGCB2BReferenceSpectralSpecBuilderBase {
    public static final String B2B_CAL_SETUP = " B2B Cal Setup";
    @NonNull
    private final Optional<SBGenerationContext> sbGenerationContext;
    private static final List<DGCB2BFrequencySetup> dgcB2BReferenceLookupTable = new ArrayList<DGCB2BFrequencySetup>(11);

    protected abstract void mergeSpectralSpecs(@NonNull SpectralSpec var1, @NonNull SpectralSpec var2);

    private SpectralSetupParameters buildB2BContinuumSSP(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters2 = SpectralSetupParameters.createSpectralSetupParameters();
        try {
            spectralSetupParameters.updateLO1();
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            throw new WizardSBGenerationException("Unable to update LO1 " + baseBandNotDeployableException.getMessage());
        }
        DGCB2BFrequencySetup dGCB2BFrequencySetup = DGCB2BReferenceSpectralSpecBuilderBase.lookUpDGCB2BRefData(spectralSetupParameters.getReceiverBand(), spectralSetupParameters.getLO1Frequency(), this.sbGenerationContext.get());
        spectralSetupParameters2.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM);
        spectralSetupParameters2.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        List<Frequency> list = dGCB2BFrequencySetup.getSpwCentres();
        spectralSetupParameters2.setRepresentativeFrequency(list.get(list.size() - 1).deepCopy());
        spectralSetupParameters2.setSingleContinuumFrequency(dGCB2BFrequencySetup.getSingleContinuumFrequency().deepCopy());
        spectralSetupParameters2.updateSingleContinuumWindows(dGCB2BFrequencySetup.getSingleContinuumFrequency().deepCopy(), Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY, CorrPolarization.DOUBLE);
        SpectralSetupFactory.createB2BWindows(Optional.of(spectralSetupParameters2), list);
        return spectralSetupParameters2;
    }

    public static DGCB2BFrequencySetup lookUpDGCB2BRefData(@NonNull ReceiverBand receiverBand, @NonNull Frequency frequency, SBGenerationContext sBGenerationContext) {
        Enum enum_;
        if (receiverBand == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("LO1 is marked non-null but is null");
        }
        Enum enum_2 = enum_ = sBGenerationContext == null ? Array.ARRAY_12M : sBGenerationContext.getArray();
        if (sBGenerationContext == null) {
            Log.logger(DGCB2BReferenceSpectralSpecBuilderBase.class).warning("Defaulting to 12-m DGC timings");
        }
        return dgcB2BReferenceLookupTable.stream().filter(dGCB2BFrequencySetup -> dGCB2BFrequencySetup.getScienceReceiverBand().equals(receiverBand) && dGCB2BFrequencySetup.getLo1Range().contains(frequency) && dGCB2BFrequencySetup.getArray().equals(enum_)).findFirst().orElseThrow(WizardSBGenerationException::new);
    }

    public SpectralSpec createDGCReferenceB2BSpectralSpec(@NonNull SpectralSpec spectralSpec, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull SpectralSpecWorker spectralSpecWorker) {
        if (spectralSpec == null) {
            throw new NullPointerException("scienceSpectralSpec is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (spectralSpecWorker == null) {
            throw new NullPointerException("spectralSpecWorker is marked non-null but is null");
        }
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal().deepCopy();
        SpectralSetupParameters spectralSetupParameters2 = this.buildB2BContinuumSSP(spectralSetupParameters);
        spectralSetupParameters2.setDerivedForDGCCalibrator(true);
        scienceGoal.setSpectralSetupParameters(spectralSetupParameters2);
        SpectralSpec spectralSpec2 = spectralSpec.isBLSpectralSpec() ? SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(this.sbGenerationContext) : SpectralSpec.createSpectralSpecWithACACorrelatorConfiguration(this.sbGenerationContext);
        spectralSpecWorker.setupScienceSpectralSpec(spectralSpec2, spectralSetupParameters2, true);
        Velocity velocity = Velocity.createVelocity();
        velocity.setReferenceSystem(Velocity.REFERENCESYSTEM_TOPO);
        spectralSpec2.setSourceVelocity(velocity);
        ReceiverBand receiverBand = spectralSpec2.getReceiverBand();
        spectralSpec2.setName("B" + receiverBand.getNumber() + B2B_CAL_SETUP);
        spectralSpec2.setLOInSpectralSpec(velocity.deepCopy());
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        this.mergeSpectralSpecs(spectralSpec2, spectralSpec);
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec2.getBaseBandConfig()) {
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                spectralWindowI.updateSideband();
            }
        }
        return spectralSpec2;
    }

    public DGCB2BReferenceSpectralSpecBuilderBase(@NonNull Optional<SBGenerationContext> optional) {
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        this.sbGenerationContext = optional;
    }

    public String toString() {
        return "DGCB2BReferenceSpectralSpecBuilderBase(sbGenerationContext=" + String.valueOf(this.sbGenerationContext) + ")";
    }

    static {
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(282.9), Frequency.createFrequencyGHZ(323.999))).scienceReceiverBand(ReceiverBand.getReceiverBand(7)).referenceReceiverBand(ReceiverBand.getReceiverBand(3)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(90.5), Frequency.createFrequencyGHZ(92.5), Frequency.createFrequencyGHZ(102.5), Frequency.createFrequencyGHZ(104.5))).singleContinuumFrequency(Frequency.createFrequencyGHZ(97.5)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(54.0)).dgcRefCalIntegrationTime(Time.createTimeSec(12.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(24.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(324.0), Frequency.createFrequencyGHZ(365.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(7)).referenceReceiverBand(ReceiverBand.getReceiverBand(3)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.NONHARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(90.5), Frequency.createFrequencyGHZ(92.5), Frequency.createFrequencyGHZ(102.5), Frequency.createFrequencyGHZ(104.5))).singleContinuumFrequency(Frequency.createFrequencyGHZ(97.5)).internalCycleCount(3).checkSourceIntTime(Time.createTimeSec(54.0)).dgcRefCalIntegrationTime(Time.createTimeSec(12.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(24.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(393.0), Frequency.createFrequencyGHZ(399.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(8)).referenceReceiverBand(ReceiverBand.getReceiverBand(4)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.NONHARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(148.0), Frequency.createFrequencyGHZ(150.0), Frequency.createFrequencyGHZ(160.0), Frequency.createFrequencyGHZ(162.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(155.0)).internalCycleCount(3).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).checkSourceIntTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(399.0), Frequency.createFrequencyGHZ(465.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(8)).referenceReceiverBand(ReceiverBand.getReceiverBand(4)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(148.0), Frequency.createFrequencyGHZ(150.0), Frequency.createFrequencyGHZ(160.0), Frequency.createFrequencyGHZ(162.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(155.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(49.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(12.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(465.0), Frequency.createFrequencyGHZ(492.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(8)).referenceReceiverBand(ReceiverBand.getReceiverBand(6)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(224.0), Frequency.createFrequencyGHZ(226.0), Frequency.createFrequencyGHZ(240.0), Frequency.createFrequencyGHZ(242.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(233.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(49.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(12.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(610.2), Frequency.createFrequencyGHZ(697.5))).scienceReceiverBand(ReceiverBand.getReceiverBand(9)).referenceReceiverBand(ReceiverBand.getReceiverBand(4)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(148.0), Frequency.createFrequencyGHZ(150.0), Frequency.createFrequencyGHZ(160.0), Frequency.createFrequencyGHZ(162.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(155.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(41.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(697.5), Frequency.createFrequencyGHZ(711.9))).scienceReceiverBand(ReceiverBand.getReceiverBand(9)).referenceReceiverBand(ReceiverBand.getReceiverBand(6)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(224.0), Frequency.createFrequencyGHZ(226.0), Frequency.createFrequencyGHZ(240.0), Frequency.createFrequencyGHZ(242.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(233.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(41.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(794.7), Frequency.createFrequencyGHZ(820.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(5)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(196.0), Frequency.createFrequencyGHZ(198.0), Frequency.createFrequencyGHZ(208.0), Frequency.createFrequencyGHZ(210.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(203.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(30.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).dgcSubscanTime(Time.createTimeSec(12.288)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(820.0), Frequency.createFrequencyGHZ(830.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(5)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(196.0), Frequency.createFrequencyGHZ(198.0), Frequency.createFrequencyGHZ(208.0), Frequency.createFrequencyGHZ(210.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(203.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(30.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).dgcSubscanTime(Time.createTimeSec(12.288)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(830.0), Frequency.createFrequencyGHZ(848.7))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(5)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(196.0), Frequency.createFrequencyGHZ(198.0), Frequency.createFrequencyGHZ(208.0), Frequency.createFrequencyGHZ(210.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(203.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(30.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).dgcSubscanTime(Time.createTimeSec(12.288)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(848.7), Frequency.createFrequencyGHZ(942.3))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(7)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(336.5), Frequency.createFrequencyGHZ(338.5), Frequency.createFrequencyGHZ(348.5), Frequency.createFrequencyGHZ(350.5))).singleContinuumFrequency(Frequency.createFrequencyGHZ(343.5)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(30.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(16.0)).dgcRefCalIntegrationTime(Time.createTimeSec(8.0)).dgcSubscanTime(Time.createTimeSec(12.288)).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(282.9), Frequency.createFrequencyGHZ(324.9))).scienceReceiverBand(ReceiverBand.getReceiverBand(7)).referenceReceiverBand(ReceiverBand.getReceiverBand(3)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(90.5), Frequency.createFrequencyGHZ(92.5), Frequency.createFrequencyGHZ(102.5), Frequency.createFrequencyGHZ(104.5))).singleContinuumFrequency(Frequency.createFrequencyGHZ(97.5)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(54.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(324.0), Frequency.createFrequencyGHZ(365.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(7)).referenceReceiverBand(ReceiverBand.getReceiverBand(3)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.NONHARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(90.5), Frequency.createFrequencyGHZ(92.5), Frequency.createFrequencyGHZ(102.5), Frequency.createFrequencyGHZ(104.5))).singleContinuumFrequency(Frequency.createFrequencyGHZ(97.5)).internalCycleCount(3).checkSourceIntTime(Time.createTimeSec(54.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(393.0), Frequency.createFrequencyGHZ(399.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(8)).referenceReceiverBand(ReceiverBand.getReceiverBand(4)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.NONHARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(148.0), Frequency.createFrequencyGHZ(150.0), Frequency.createFrequencyGHZ(160.0), Frequency.createFrequencyGHZ(162.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(155.0)).internalCycleCount(3).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).checkSourceIntTime(Time.createTimeSec(60.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(399.0), Frequency.createFrequencyGHZ(465.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(8)).referenceReceiverBand(ReceiverBand.getReceiverBand(4)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(148.0), Frequency.createFrequencyGHZ(150.0), Frequency.createFrequencyGHZ(160.0), Frequency.createFrequencyGHZ(162.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(155.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(465.0), Frequency.createFrequencyGHZ(492.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(8)).referenceReceiverBand(ReceiverBand.getReceiverBand(6)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(224.0), Frequency.createFrequencyGHZ(226.0), Frequency.createFrequencyGHZ(240.0), Frequency.createFrequencyGHZ(242.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(233.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(610.2), Frequency.createFrequencyGHZ(697.5))).scienceReceiverBand(ReceiverBand.getReceiverBand(9)).referenceReceiverBand(ReceiverBand.getReceiverBand(4)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(148.0), Frequency.createFrequencyGHZ(150.0), Frequency.createFrequencyGHZ(160.0), Frequency.createFrequencyGHZ(162.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(155.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(697.5), Frequency.createFrequencyGHZ(711.9))).scienceReceiverBand(ReceiverBand.getReceiverBand(9)).referenceReceiverBand(ReceiverBand.getReceiverBand(6)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(224.0), Frequency.createFrequencyGHZ(226.0), Frequency.createFrequencyGHZ(240.0), Frequency.createFrequencyGHZ(242.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(233.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(794.7), Frequency.createFrequencyGHZ(820.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(5)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(196.0), Frequency.createFrequencyGHZ(198.0), Frequency.createFrequencyGHZ(208.0), Frequency.createFrequencyGHZ(210.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(203.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(820.0), Frequency.createFrequencyGHZ(830.0))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(5)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(196.0), Frequency.createFrequencyGHZ(198.0), Frequency.createFrequencyGHZ(208.0), Frequency.createFrequencyGHZ(210.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(203.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(830.0), Frequency.createFrequencyGHZ(848.7))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(5)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(196.0), Frequency.createFrequencyGHZ(198.0), Frequency.createFrequencyGHZ(208.0), Frequency.createFrequencyGHZ(210.0))).singleContinuumFrequency(Frequency.createFrequencyGHZ(203.0)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
        dgcB2BReferenceLookupTable.add(DGCB2BFrequencySetup.builder().lo1Range(new FrequencyRange(Frequency.createFrequencyGHZ(848.7), Frequency.createFrequencyGHZ(942.3))).scienceReceiverBand(ReceiverBand.getReceiverBand(10)).referenceReceiverBand(ReceiverBand.getReceiverBand(7)).frequencySwitchingMode(DGCB2BFrequencySetup.HarmonicEnum.HARMONIC).spwCentres(List.of(Frequency.createFrequencyGHZ(336.5), Frequency.createFrequencyGHZ(338.5), Frequency.createFrequencyGHZ(348.5), Frequency.createFrequencyGHZ(350.5))).singleContinuumFrequency(Frequency.createFrequencyGHZ(343.5)).internalCycleCount(5).checkSourceIntTime(Time.createTimeSec(60.0)).dgcScienceCalIntegrationTime(Time.createTimeSec(30.0)).dgcRefCalIntegrationTime(Time.createTimeSec(30.0)).array(RequestedArray.SEVEN_M).build());
    }
}

