/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.ousgenerator;

import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import alma.obsprep.services.generator.refactored.ousgenerator.ObservatoryGoalOUSGenerator;
import alma.obsprep.services.generator.refactored.ousgenerator.ScienceGoalOUSGenerator;
import lombok.NonNull;

public final class OUSGeneratorFactory {
    public static OUSGenerator getOUSGenerator(@NonNull CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        if (calibratedAbstractScienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (calibratedAbstractScienceGoal instanceof ScienceGoal) {
            return new ScienceGoalOUSGenerator((ScienceGoal)calibratedAbstractScienceGoal);
        }
        if (calibratedAbstractScienceGoal instanceof ObservatoryGoal) {
            return new ObservatoryGoalOUSGenerator((ObservatoryGoal)calibratedAbstractScienceGoal);
        }
        throw new IllegalArgumentException("Unhandled goal type:" + calibratedAbstractScienceGoal.getClass().getSimpleName());
    }

    private OUSGeneratorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

