/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.ObservatoryGoalObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;

public class CalibratorSurveyObservingParametersFactory
extends ObservatoryGoalObservingParametersFactory {
    private final Time targetIntegrationTime;

    public CalibratorSurveyObservingParametersFactory(SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, Time time, SBGenerationContext sBGenerationContext) {
        super(spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        this.targetIntegrationTime = time.deepCopy();
    }

    @Override
    protected AmplitudeCalParameters getAmplitudeCalParameters(int n) {
        AmplitudeCalParameters amplitudeCalParameters = super.getAmplitudeCalParameters(n);
        if (n == 2) {
            amplitudeCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
            amplitudeCalParameters.setName("Survey Target Amplitude Parameters");
            amplitudeCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            amplitudeCalParameters.setSubScanDuration(Time.createTimeSec(0.0));
        }
        this.setMissingParameters((CalibratorParameters)((Object)amplitudeCalParameters));
        return amplitudeCalParameters;
    }
}

