/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import lombok.NonNull;
import org.apache.commons.math3.util.ArithmeticUtils;

public final class TPReferencePositionWorker {
    private static Longitude defaultReferencePositionLongitude = Longitude.createLongitude((double)600.0, (String)Longitude.UNIT_ARCSEC);

    public static void setupReferencePosition(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        if (!target.hasAmplitudeCalParameters() && !target.hasScienceParameters()) {
            throw new WizardSBGenerationException("Only ampcals and science targets may have a reference position attached.");
        }
        for (Reference reference : target.getFieldSource().getReference()) {
            Time time;
            SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
            skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
            skyCoordinates.setLongitude(defaultReferencePositionLongitude.deepCopy());
            reference.setReferenceCoordinates(skyCoordinates);
            Time time2 = TPReferencePositionWorker.getFieldReferenceIntegrationTime(target, defaultReferencePositionLongitude.getArcsec());
            reference.setIntegrationTime(time2);
            if (target.hasAmplitudeCalParameters()) {
                var9_10 = target.getAmplitudeCalParametersList()[0];
                time = (Time)var9_10.getSubScanDuration().multiply(0.95);
            } else if (target.hasScienceParameters()) {
                var9_10 = target.getScienceParametersList()[0];
                time = (Time)var9_10.getSubScanDuration().multiply(0.95);
            } else {
                throw new WizardSBGenerationException("Unable to determine reference cycle time for any other target type but science and amp cal");
            }
            reference.setCycleTime(time);
            double d = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
            double d2 = time2.getContentInUnits(Time.UNIT_MS);
            long l = ArithmeticUtils.lcm((long)((long)d), (long)48L);
            double d3 = Math.ceil(d2 / (double)l) * (double)l;
            Time time3 = Time.createTime((double)(d3 / 1000.0), (String)Time.UNIT_S);
            reference.setSubScanDuration(time3);
        }
    }

    private static Time getFieldReferenceIntegrationTime(@NonNull Target target, double d) {
        double d2;
        Object object;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        if (target.hasAmplitudeCalParameters()) {
            object = target.getAmplitudeCalParametersList()[0];
            d2 = object.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        } else if (target.hasScienceParameters()) {
            object = target.getScienceParametersList()[0];
            d2 = object.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        } else {
            throw new WizardSBGenerationException("Unable to determine t_sub for any other target but science and amp cal");
        }
        try {
            object = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle = UserAngle.createUserAngle(6.3, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, (Frequency)((Object)object));
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        double d3 = userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC) * 1.0;
        double d4 = Math.sqrt(1.0 * (d2 + 1.0) * (d3 * d2 / d / 5.0));
        return Time.createTimeSec(d4);
    }

    private TPReferencePositionWorker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

