/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ObservingGroupManager {
    private Integer observingGroupCounter = 0;
    public static final String CALIBRATOR_GROUP_NAME = "Calibrators 1";
    public static final String SCIENCE_GROUP_NAME = "Science 1";
    private final Map<String, ObservingGroupData> observingGroupMap = new ConcurrentHashMap<String, ObservingGroupData>(8, 0.9f, 1);

    public ObservingGroupType getObservingGroupType(String string) throws ObservingGroupNotFoundException {
        if (!this.observingGroupMap.containsKey(string)) {
            throw new ObservingGroupNotFoundException("The group " + string + " does not exist in the map");
        }
        return this.observingGroupMap.get(string).getObservingGroupIndex() > 1 ? ObservingGroupType.SCIENCE : ObservingGroupType.CALIBRATOR;
    }

    public ObservingGroupType getObservingGroupType(Integer n) throws ObservingGroupNotFoundException {
        for (String string : this.observingGroupMap.keySet()) {
            if (!this.observingGroupMap.get(string).getObservingGroupIndex().equals(n)) continue;
            return this.observingGroupMap.get(string).getObservingGroupType();
        }
        throw new ObservingGroupNotFoundException("The group index " + n + " does not exist in the map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getObservingGroupIndex(ObservingGroupType observingGroupType, Integer n) {
        String string = observingGroupType.getGroupLabelPrefix() + " " + n;
        try {
            return this.getObservingGroupIndex(string);
        }
        catch (ObservingGroupNotFoundException observingGroupNotFoundException) {
            ObservingGroupManager observingGroupManager = this;
            synchronized (observingGroupManager) {
                Integer n2 = this.observingGroupCounter;
                this.observingGroupCounter = this.observingGroupCounter + 1;
                this.observingGroupMap.put(string, new ObservingGroupData(observingGroupType, this.observingGroupCounter, string));
            }
            return this.observingGroupCounter;
        }
    }

    public ObservingGroupData getObservingGroupByIndex(Integer n) throws ObservingGroupNotFoundException {
        for (ObservingGroupData observingGroupData : this.observingGroupMap.values()) {
            if (!observingGroupData.getObservingGroupIndex().equals(n)) continue;
            return observingGroupData;
        }
        throw new ObservingGroupNotFoundException("Unable to locate observing group " + n);
    }

    public Integer getObservingGroupIndex(String string) throws ObservingGroupNotFoundException {
        if (this.observingGroupMap.containsKey(string)) {
            return this.observingGroupMap.get(string).getObservingGroupIndex();
        }
        throw new ObservingGroupNotFoundException("The group " + string + " is unknown");
    }

    public List<String> getOrderedListOfObservingGroupNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.observingGroupMap.keySet());
        Collections.sort(arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public static class ObservingGroupNotFoundException
    extends Exception {
        public ObservingGroupNotFoundException() {
        }

        public ObservingGroupNotFoundException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ObservingGroupNotFoundException(String string) {
            super(string);
        }

        public ObservingGroupNotFoundException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class ObservingGroupData {
        private ObservingGroupType observingGroupType;
        private Integer observingGroupIndex;
        private String observingGroupName;

        public String toString() {
            return "ObservingGroupData [observingGroupType=" + String.valueOf((Object)this.observingGroupType) + ", observingGroupIndex=" + this.observingGroupIndex + ", observingGroupName=" + this.observingGroupName + "]";
        }

        public ObservingGroupType getObservingGroupType() {
            return this.observingGroupType;
        }

        public Integer getObservingGroupIndex() {
            return this.observingGroupIndex;
        }

        public String getObservingGroupName() {
            return this.observingGroupName;
        }

        public ObservingGroupData(ObservingGroupType observingGroupType, Integer n, String string) {
            this.observingGroupType = observingGroupType;
            this.observingGroupIndex = n;
            this.observingGroupName = string;
        }
    }

    public static enum ObservingGroupType {
        CALIBRATOR("Calibrators", 1),
        SCIENCE("Science", 2);

        private String groupLabelPrefix;
        private Integer nominalObservingGroup;

        public static ObservingGroupType getObservingGroupType(String string) throws ObservingGroupNotFoundException {
            for (ObservingGroupType observingGroupType : ObservingGroupType.values()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)observingGroupType.getGroupLabelPrefix())) continue;
                return observingGroupType;
            }
            throw new ObservingGroupNotFoundException("Unable to determine observing group type for : " + string);
        }

        private ObservingGroupType(String string2, Integer n2) {
            this.groupLabelPrefix = string2;
            this.nominalObservingGroup = n2;
        }

        public String getGroupLabelPrefix() {
            return this.groupLabelPrefix;
        }

        public Integer getNominalObservingGroup() {
            return this.nominalObservingGroup;
        }
    }
}

