/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.dgcpostprocessor;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.models.schedblock.observingparameters.PhaseCalParameterModel;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.DGCObservingParametersFactory;
import alma.valuetypes.Time;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

abstract class B2BParameterConfigurator
implements DGCObservingParametersFactory.DGCParameterConfiguratorInterface {
    @NonNull
    protected SchedBlock sb;

    @Override
    public void configureDGCReferenceBandpass() {
        List<Target> list = this.sb.getAllTargets(BandpassCalParameters.bandpassParametersFilter);
        list.stream().filter(target -> StringUtils.contains((CharSequence)target.getSpectralSpec().getName(), (CharSequence)"B2B Cal Setup")).findFirst().ifPresent(target -> {
            BandpassCalParameters bandpassCalParameters = target.getFirstBandpassCalParameters().orElseThrow(WizardSBGenerationException::new);
            bandpassCalParameters.setDefaultIntegrationTime(Time.createTimeMin(5.0));
        });
    }

    protected void setCheckSourceCycleTime4xPhaseCalRepeatInterval(@NonNull CheckSourceCalParameters checkSourceCalParameters) {
        if (checkSourceCalParameters == null) {
            throw new NullPointerException("checkSourceCalParameters is marked non-null but is null");
        }
        Target target2 = this.sb.getAllTargets(CheckSourceCalParameters.CheckSourceParametersFilter).stream().filter(target -> ((Object)((Object)target.getFirstCheckSourceCalParameters().orElseThrow(WizardSBGenerationException::new))).equals((Object)checkSourceCalParameters)).findFirst().orElseThrow(WizardSBGenerationException::new);
        ObservingGroup[] observingGroupArray = target2.getObservingGroupList();
        if (observingGroupArray.length != 1) {
            throw new WizardSBGenerationException("Expecting the check source to be in only one observing group");
        }
        ObservingGroup observingGroup = observingGroupArray[0];
        List<Target> list = observingGroup.getAllOrderedTargets(PhaseCalParameters.phaseCalParametersFilter);
        if (list.size() != 1) {
            Log.logger(B2BParameterConfigurator.class).info("Expecting a single phase cal in the same OG as the check source");
            return;
        }
        Target target3 = list.get(0);
        @NonNull Time time = PhaseCalParameterModel.determinePhaseCalRepeatInterval((CalibratorParameters)((Object)target3.getFirstPhaseCalParameters().orElseThrow(WizardSBGenerationException::new)));
        checkSourceCalParameters.setCycleTime((Time)time.multiply(4.0));
    }

    public B2BParameterConfigurator(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

