/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.SquareLawSetupData;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.data.TimeData;
import java.util.List;
import lombok.NonNull;

public class TPSquareLawGenerator {
    @NonNull
    private final SchedBlock sb;

    public void process() {
        SBGenerationContext sBGenerationContext = this.sb.getSbGenerationContext();
        try {
            if (!sBGenerationContext.getArray().isTP() || !sBGenerationContext.getGoal().isSolarScienceGoal()) {
                return;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException(unknownEntityException);
        }
        this.convertScienceTargetsToSquareLawDetectorSetup();
        this.convertPointingTargetsToSquareLawDetectorSetup();
        this.convertTargetsFrequencySetupToTopo();
    }

    private void convertTargetsFrequencySetupToTopo() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        list.addAll(this.sb.getAllTargets(PointingCalParameters.pointingCalParametersFilter));
        list.stream().forEach(target -> target.getSpectralSpec().getFrequencySetup().setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO));
    }

    private void convertScienceTargetsToSquareLawDetectorSetup() {
        for (Target target : this.sb.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            SquareLawSetup squareLawSetup = SquareLawSetupData.createSquareLawSetup();
            squareLawSetup.setIntegrationDuration(TimeData.createTime((double)1.0, (String)TimeData.UNIT_MS));
            SpectralSpec spectralSpec = target.getSpectralSpec();
            spectralSpec.setAbstractCorrelatorConfiguration(null);
            spectralSpec.setSquareLawSetup(squareLawSetup);
        }
    }

    private void convertPointingTargetsToSquareLawDetectorSetup() {
        for (Target target : this.sb.getAllTargets(PointingCalParameters.pointingCalParametersFilter)) {
            SquareLawSetup squareLawSetup = SquareLawSetupData.createSquareLawSetup();
            squareLawSetup.setIntegrationDuration(TimeData.createTime((double)16.0, (String)TimeData.UNIT_MS));
            SpectralSpec spectralSpec = target.getSpectralSpec();
            spectralSpec.setAbstractCorrelatorConfiguration(null);
            spectralSpec.setSquareLawSetup(squareLawSetup);
        }
    }

    public TPSquareLawGenerator(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

